/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base;

import com.hedera.hashgraph.sdk.FileId;
import com.openelements.hedera.base.HederaException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;

public interface FileClient {
    @NonNull
    public FileId createFile(@NonNull byte[] var1) throws HederaException;

    public FileId createFile(@NonNull byte[] var1, @NonNull Instant var2) throws HederaException;

    @NonNull
    default public byte[] readFile(@NonNull String fileId) throws HederaException {
        Objects.requireNonNull(fileId, "fileId must not be null");
        return this.readFile(FileId.fromString((String)fileId));
    }

    @NonNull
    public byte[] readFile(@NonNull FileId var1) throws HederaException;

    default public void deleteFile(@NonNull String fileId) throws HederaException {
        this.deleteFile(FileId.fromString((String)fileId));
    }

    public void deleteFile(@NonNull FileId var1) throws HederaException;

    public void updateFile(@NonNull FileId var1, byte[] var2) throws HederaException;

    public void updateExpirationTime(@NonNull FileId var1, @NonNull Instant var2) throws HederaException;

    public boolean isDeleted(@NonNull FileId var1) throws HederaException;

    public int getSize(@NonNull FileId var1) throws HederaException;

    public Instant getExpirationTime(@NonNull FileId var1) throws HederaException;
}

