/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.TokenId;
import com.openelements.hedera.base.Account;
import com.openelements.hedera.base.HederaException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;

public interface NftClient {
    @NonNull
    public TokenId createNftType(@NonNull String var1, @NonNull String var2) throws HederaException;

    @NonNull
    public TokenId createNftType(@NonNull String var1, @NonNull String var2, @NonNull PrivateKey var3) throws HederaException;

    @NonNull
    public TokenId createNftType(@NonNull String var1, @NonNull String var2, @NonNull AccountId var3, @NonNull PrivateKey var4) throws HederaException;

    @NonNull
    default public TokenId createNftType(@NonNull String name, @NonNull String symbol, @NonNull Account treasuryAccount) throws HederaException {
        Objects.requireNonNull(treasuryAccount, "treasuryAccount must not be null");
        return this.createNftType(name, symbol, treasuryAccount.accountId(), treasuryAccount.privateKey());
    }

    @NonNull
    public TokenId createNftType(@NonNull String var1, @NonNull String var2, @NonNull AccountId var3, @NonNull PrivateKey var4, @NonNull PrivateKey var5) throws HederaException;

    @NonNull
    default public TokenId createNftType(@NonNull String name, @NonNull String symbol, @NonNull Account treasuryAccount, @NonNull PrivateKey supplierKey) throws HederaException {
        Objects.requireNonNull(treasuryAccount, "treasuryAccount must not be null");
        return this.createNftType(name, symbol, treasuryAccount.accountId(), treasuryAccount.privateKey(), supplierKey);
    }

    public void associateNft(@NonNull TokenId var1, @NonNull AccountId var2, @NonNull PrivateKey var3) throws HederaException;

    default public void associateNft(@NonNull TokenId tokenId, @NonNull Account account) throws HederaException {
        Objects.requireNonNull(account, "account must not be null");
        this.associateNft(tokenId, account.accountId(), account.privateKey());
    }

    public long mintNft(@NonNull TokenId var1, @NonNull String var2) throws HederaException;

    public long mintNft(@NonNull TokenId var1, @NonNull String var2, @NonNull PrivateKey var3) throws HederaException;

    @NonNull
    public List<Long> mintNfts(@NonNull TokenId var1, @NonNull List<String> var2) throws HederaException;

    @NonNull
    public List<Long> mintNfts(@NonNull TokenId var1, @NonNull List<String> var2, @NonNull PrivateKey var3) throws HederaException;

    public void transferNft(@NonNull TokenId var1, long var2, @NonNull AccountId var4, @NonNull PrivateKey var5, @NonNull AccountId var6) throws HederaException;

    default public void transferNft(@NonNull TokenId tokenId, long serialNumber, @NonNull Account fromAccount, @NonNull AccountId toAccountId) throws HederaException {
        Objects.requireNonNull(fromAccount, "fromAccount must not be null");
        this.transferNft(tokenId, serialNumber, fromAccount.accountId(), fromAccount.privateKey(), toAccountId);
    }

    public void transferNfts(@NonNull TokenId var1, @NonNull List<Long> var2, @NonNull AccountId var3, @NonNull PrivateKey var4, @NonNull AccountId var5) throws HederaException;

    default public void transferNfts(@NonNull TokenId tokenId, @NonNull List<Long> serialNumbers, @NonNull Account fromAccount, @NonNull AccountId toAccountId) throws HederaException {
        Objects.requireNonNull(fromAccount, "fromAccount must not be null");
        this.transferNfts(tokenId, serialNumbers, fromAccount.accountId(), fromAccount.privateKey(), toAccountId);
    }
}

