/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base.implementation;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.openelements.hedera.base.Account;
import com.openelements.hedera.base.AccountClient;
import com.openelements.hedera.base.HederaException;
import com.openelements.hedera.base.protocol.AccountBalanceRequest;
import com.openelements.hedera.base.protocol.AccountBalanceResponse;
import com.openelements.hedera.base.protocol.AccountCreateRequest;
import com.openelements.hedera.base.protocol.AccountCreateResult;
import com.openelements.hedera.base.protocol.AccountDeleteRequest;
import com.openelements.hedera.base.protocol.ProtocolLayerClient;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class AccountClientImpl
implements AccountClient {
    private final ProtocolLayerClient client;

    public AccountClientImpl(@NonNull ProtocolLayerClient client) {
        this.client = Objects.requireNonNull(client, "client must not be null");
    }

    @Override
    @NonNull
    public Account createAccount(@NonNull Hbar initialBalance) throws HederaException {
        AccountCreateRequest request = AccountCreateRequest.of(initialBalance);
        AccountCreateResult result = this.client.executeAccountCreateTransaction(request);
        return new Account(result.accountId(), result.publicKey(), result.privateKey());
    }

    @Override
    public void deleteAccount(@NonNull AccountId account) throws HederaException {
        AccountDeleteRequest request = AccountDeleteRequest.of(account);
        this.client.executeAccountDeleteTransaction(request);
    }

    @Override
    @NonNull
    public Hbar getAccountBalance(@NonNull AccountId account) throws HederaException {
        AccountBalanceRequest request = AccountBalanceRequest.of(account);
        AccountBalanceResponse response = this.client.executeAccountBalanceQuery(request);
        return response.hbars();
    }
}

