/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base.implementation;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TokenType;
import com.openelements.hedera.base.HederaException;
import com.openelements.hedera.base.NftClient;
import com.openelements.hedera.base.protocol.ProtocolLayerClient;
import com.openelements.hedera.base.protocol.TokenAssociateRequest;
import com.openelements.hedera.base.protocol.TokenCreateRequest;
import com.openelements.hedera.base.protocol.TokenCreateResult;
import com.openelements.hedera.base.protocol.TokenMintRequest;
import com.openelements.hedera.base.protocol.TokenMintResult;
import com.openelements.hedera.base.protocol.TokenTransferRequest;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class NftClientImpl
implements NftClient {
    private final ProtocolLayerClient client;
    private final AccountId adminAccount;
    private final PrivateKey adminSupplyKey;

    public NftClientImpl(@NonNull ProtocolLayerClient client, @NonNull AccountId adminAccount, @NonNull PrivateKey adminSupplyKey) {
        this.client = Objects.requireNonNull(client, "client must not be null");
        this.adminAccount = Objects.requireNonNull(adminAccount, "adminAccount must not be null");
        this.adminSupplyKey = Objects.requireNonNull(adminSupplyKey, "adminSupplyKey must not be null");
    }

    @Override
    public TokenId createNftType(@NonNull String name, @NonNull String symbol) throws HederaException {
        return this.createNftType(name, symbol, this.adminAccount, this.adminSupplyKey);
    }

    @Override
    public TokenId createNftType(@NonNull String name, @NonNull String symbol, @NonNull PrivateKey supplierKey) throws HederaException {
        return this.createNftType(name, symbol, this.adminAccount, this.adminSupplyKey, supplierKey);
    }

    @Override
    public TokenId createNftType(@NonNull String name, @NonNull String symbol, @NonNull AccountId treasuryAccountId, @NonNull PrivateKey treasuryKey) throws HederaException {
        return this.createNftType(name, symbol, treasuryAccountId, treasuryKey, this.adminSupplyKey);
    }

    @Override
    public TokenId createNftType(@NonNull String name, @NonNull String symbol, @NonNull AccountId treasuryAccountId, @NonNull PrivateKey treasuryKey, @NonNull PrivateKey supplierKey) throws HederaException {
        TokenCreateRequest request = TokenCreateRequest.of(name, symbol, treasuryAccountId, treasuryKey, TokenType.NON_FUNGIBLE_UNIQUE, supplierKey);
        TokenCreateResult tokenCreateResult = this.client.executeTokenCreateTransaction(request);
        return tokenCreateResult.tokenId();
    }

    @Override
    public void associateNft(@NonNull TokenId tokenId, @NonNull AccountId accountId, @NonNull PrivateKey accountKey) throws HederaException {
        TokenAssociateRequest request = TokenAssociateRequest.of(tokenId, accountId, accountKey);
        this.client.executeTokenAssociateTransaction(request);
    }

    @Override
    public long mintNft(@NonNull TokenId tokenId, @NonNull String metadata) throws HederaException {
        return this.mintNft(tokenId, metadata, this.adminSupplyKey);
    }

    @Override
    public List<Long> mintNfts(@NonNull TokenId tokenId, @NonNull List<String> metadata) throws HederaException {
        return this.mintNfts(tokenId, metadata, this.adminSupplyKey);
    }

    @Override
    public long mintNft(@NonNull TokenId tokenId, @NonNull String metadata, @NonNull PrivateKey supplyKey) throws HederaException {
        TokenMintRequest request = TokenMintRequest.of(tokenId, supplyKey, metadata);
        TokenMintResult tokenMintResult = this.client.executeMintTokenTransaction(request);
        List<Long> serials = tokenMintResult.serials();
        if (serials.size() != 1) {
            throw new HederaException("Expected 1 serial number, but got " + serials.size());
        }
        return serials.get(0);
    }

    @Override
    public List<Long> mintNfts(@NonNull TokenId tokenId, @NonNull List<String> metadata, @NonNull PrivateKey supplyKey) throws HederaException {
        TokenMintRequest request = TokenMintRequest.of(tokenId, supplyKey, metadata);
        TokenMintResult result = this.client.executeMintTokenTransaction(request);
        return Collections.unmodifiableList(result.serials());
    }

    @Override
    public void transferNft(@NonNull TokenId tokenId, long serialNumber, @NonNull AccountId fromAccountId, @NonNull PrivateKey fromAccountKey, @NonNull AccountId toAccountId) throws HederaException {
        this.transferNfts(tokenId, List.of(Long.valueOf(serialNumber)), fromAccountId, fromAccountKey, toAccountId);
    }

    @Override
    public void transferNfts(@NonNull TokenId tokenId, @NonNull List<Long> serialNumber, @NonNull AccountId fromAccountId, @NonNull PrivateKey fromAccountKey, @NonNull AccountId toAccountId) throws HederaException {
        TokenTransferRequest request = TokenTransferRequest.of(tokenId, serialNumber, fromAccountId, toAccountId, fromAccountKey);
        this.client.executeTransferTransactionForNft(request);
    }
}

