/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base.implementation;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.TokenId;
import com.openelements.hedera.base.HederaException;
import com.openelements.hedera.base.Nft;
import com.openelements.hedera.base.NftRepository;
import com.openelements.hedera.base.mirrornode.MirrorNodeClient;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NftRepositoryImpl
implements NftRepository {
    private final MirrorNodeClient mirrorNodeClient;

    public NftRepositoryImpl(@NonNull MirrorNodeClient mirrorNodeClient) {
        this.mirrorNodeClient = Objects.requireNonNull(mirrorNodeClient, "mirrorNodeClient must not be null");
    }

    @Override
    @NonNull
    public List<Nft> findByOwner(@NonNull AccountId owner) throws HederaException {
        return this.mirrorNodeClient.queryNftsByAccount(owner);
    }

    @Override
    @NonNull
    public List<Nft> findByType(@NonNull TokenId tokenId) throws HederaException {
        return this.mirrorNodeClient.queryNftsByTokenId(tokenId);
    }

    @Override
    @NonNull
    public Optional<Nft> findByTypeAndSerial(@NonNull TokenId tokenId, long serialNumber) throws HederaException {
        return this.mirrorNodeClient.queryNftsByTokenIdAndSerial(tokenId, serialNumber);
    }

    @Override
    @NonNull
    public List<Nft> findByOwnerAndType(@NonNull AccountId owner, @NonNull TokenId tokenId) throws HederaException {
        return this.mirrorNodeClient.queryNftsByAccountAndTokenId(owner, tokenId);
    }

    @Override
    @NonNull
    public Optional<Nft> findByOwnerAndTypeAndSerial(@NonNull AccountId owner, @NonNull TokenId tokenId, long serialNumber) throws HederaException {
        return this.mirrorNodeClient.queryNftsByAccountAndTokenIdAndSerial(owner, tokenId, serialNumber);
    }
}

