/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base.implementation;

import com.hedera.hashgraph.sdk.ContractFunctionResult;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.FileId;
import com.openelements.hedera.base.ContractCallResult;
import com.openelements.hedera.base.ContractParam;
import com.openelements.hedera.base.FileClient;
import com.openelements.hedera.base.HederaException;
import com.openelements.hedera.base.SmartContractClient;
import com.openelements.hedera.base.implementation.ContractCallResultImpl;
import com.openelements.hedera.base.protocol.ContractCallRequest;
import com.openelements.hedera.base.protocol.ContractCreateRequest;
import com.openelements.hedera.base.protocol.ContractCreateResult;
import com.openelements.hedera.base.protocol.ProtocolLayerClient;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartContractClientImpl
implements SmartContractClient {
    private static final Logger log = LoggerFactory.getLogger(SmartContractClientImpl.class);
    private final ProtocolLayerClient protocolLayerClient;
    private final FileClient fileClient;

    public SmartContractClientImpl(@NonNull ProtocolLayerClient protocolLayerClient, FileClient fileClient) {
        this.protocolLayerClient = Objects.requireNonNull(protocolLayerClient, "protocolLevelClient must not be null");
        this.fileClient = Objects.requireNonNull(fileClient, "fileClient must not be null");
    }

    @Override
    @NonNull
    public ContractId createContract(@NonNull FileId fileId, ContractParam<?> ... constructorParams) throws HederaException {
        try {
            ContractCreateRequest request = constructorParams == null ? ContractCreateRequest.of(fileId, new ContractParam[0]) : ContractCreateRequest.of(fileId, Arrays.asList(constructorParams));
            ContractCreateResult result = this.protocolLayerClient.executeContractCreateTransaction(request);
            return result.contractId();
        }
        catch (Exception e) {
            throw new HederaException("Failed to create contract with fileId " + String.valueOf(fileId), e);
        }
    }

    @Override
    @NonNull
    public ContractId createContract(@NonNull byte[] contents, ContractParam<?> ... constructorParams) throws HederaException {
        try {
            FileId fileId = this.fileClient.createFile(contents);
            ContractId contract = this.createContract(fileId, constructorParams);
            this.fileClient.deleteFile(fileId);
            return contract;
        }
        catch (Exception e) {
            throw new HederaException("Failed to create contract out of byte array", e);
        }
    }

    @Override
    @NonNull
    public ContractId createContract(@NonNull Path pathToBin, ContractParam<?> ... constructorParams) throws HederaException {
        try {
            String content = Files.readString(pathToBin, StandardCharsets.UTF_8);
            byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
            return this.createContract(bytes, constructorParams);
        }
        catch (Exception e) {
            throw new HederaException("Failed to create contract from path " + String.valueOf(pathToBin), e);
        }
    }

    @Override
    @NonNull
    public ContractCallResult callContractFunction(@NonNull ContractId contractId, @NonNull String functionName, ContractParam<?> ... params) throws HederaException {
        try {
            ContractCallRequest request = ContractCallRequest.of(contractId, functionName, params);
            ContractFunctionResult result = this.protocolLayerClient.executeContractCallTransaction(request).contractFunctionResult();
            return new ContractCallResultImpl(result);
        }
        catch (Exception e) {
            throw new HederaException("Failed to call function '" + functionName + "' on contract with id " + String.valueOf(contractId), e);
        }
    }
}

