/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base.implementation.data;

import com.hedera.hashgraph.sdk.ContractFunctionParameters;
import com.openelements.hedera.base.implementation.data.ParamSupplier;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.BiConsumer;

public enum BooleanDatatype implements ParamSupplier<Boolean>
{
    BOOL;

    private final BiConsumer<Boolean, ContractFunctionParameters> addParam = (v, params) -> params.addBool(v.booleanValue());

    @Override
    public void addParam(@NonNull Boolean value, @NonNull ContractFunctionParameters params) {
        Objects.requireNonNull(value, "value must not be null");
        Objects.requireNonNull(params, "params must not be null");
        this.addParam.accept(value, params);
    }

    @Override
    public void addParam(boolean value, @NonNull ContractFunctionParameters params) {
        Objects.requireNonNull(params, "params must not be null");
        this.addParam.accept(value, params);
    }

    @Override
    public boolean isValidParam(Boolean value) {
        return true;
    }

    @Override
    public String getNativeType() {
        return "bool";
    }
}

