/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base.implementation.data;

import com.hedera.hashgraph.sdk.ContractFunctionParameters;
import com.openelements.hedera.base.implementation.data.ParamSupplier;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.BiConsumer;

public enum LongBasedNumericDatatypes implements ParamSupplier<Long>
{
    INT8("int8", (v, params) -> params.addInt8(v.byteValue()), -128L, 127L),
    UINT8("uint8", (v, params) -> params.addUint8(v.byteValue()), 0L, 255L),
    INT16("int16", (v, params) -> params.addInt16((int)v.shortValue()), -32768L, 32767L),
    UINT16("uint16", (v, params) -> params.addUint16((int)v.shortValue()), 0L, 65535L),
    INT32("int32", (v, params) -> params.addInt32(v.intValue()), Integer.MIN_VALUE, Integer.MAX_VALUE),
    UINT32("uint32", (v, params) -> params.addUint32(v.intValue()), 0L, 0xFFFFFFFFL),
    INT40("int40", (v, params) -> params.addInt40(v.longValue()), -549755813888L, 0x7FFFFFFFFFL),
    UINT40("uint40", (v, params) -> params.addUint40(v.longValue()), 0L, 0xFFFFFFFFFFL),
    INT48("int48", (v, params) -> params.addInt48(v.longValue()), -140737488355328L, 0x7FFFFFFFFFFFL),
    UINT48("uint48", (v, params) -> params.addUint48(v.longValue()), 0L, 0xFFFFFFFFFFFFL),
    INT56("int56", (v, params) -> params.addInt56(v.longValue()), -72057594037927936L, 0xFFFFFFFFFFFFFFL),
    UINT56("uint56", (v, params) -> params.addUint56(v.longValue()), 0L, 0x1FFFFFFFFFFFFFFL),
    INT64("int64", (v, params) -> params.addInt64(v.longValue()), Long.MIN_VALUE, Long.MAX_VALUE);

    private final BiConsumer<Long, ContractFunctionParameters> addParam;
    private final long minValue;
    private final long maxValue;
    private final String nativeType;

    private LongBasedNumericDatatypes(String nativeType, BiConsumer<Long, ContractFunctionParameters> addParam, long minValue, long maxValue) {
        this.nativeType = nativeType;
        this.addParam = addParam;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public void addParam(@NonNull Long value, ContractFunctionParameters params) {
        Objects.requireNonNull(value, "value must not be null");
        this.addParam.accept((long)value, params);
    }

    @Override
    public boolean isValidParam(Long value) {
        if (value == null) {
            return false;
        }
        return value >= this.minValue && value <= this.maxValue;
    }

    @Override
    public String getNativeType() {
        return this.nativeType;
    }

    @Override
    public void addParam(long value, @NonNull ContractFunctionParameters params) {
        Objects.requireNonNull(params, "params must not be null");
        if (value < this.minValue || value > this.maxValue) {
            throw new IllegalArgumentException("value out of range for type '" + String.valueOf(this) + "': " + value);
        }
        this.addParam.accept(value, params);
    }
}

