/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base.implementation.data;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.ContractFunctionParameters;
import com.openelements.hedera.base.implementation.data.ParamSupplier;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.BiConsumer;

public enum StringBasedDatatype implements ParamSupplier<String>
{
    STRING("string", (v, params) -> params.addString(v)),
    ADDRESS("address", (v, params) -> params.addAddress(v));

    private final String nativeType;
    private final BiConsumer<String, ContractFunctionParameters> addParam;

    private StringBasedDatatype(String nativeType, BiConsumer<String, ContractFunctionParameters> addParam) {
        this.nativeType = nativeType;
        this.addParam = addParam;
    }

    @Override
    public void addParam(String value, @NonNull ContractFunctionParameters params) {
        Objects.requireNonNull(params, "params must not be null");
        this.addParam.accept(value, params);
    }

    @Override
    public boolean isValidParam(@NonNull String value) {
        Objects.requireNonNull(value, "value must not be null");
        if (this.equals(ADDRESS)) {
            try {
                AccountId.fromString((String)value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid address", e);
            }
        }
        return true;
    }

    @Override
    public String getNativeType() {
        return this.nativeType;
    }
}

