/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base.protocol;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.openelements.hedera.base.protocol.QueryRequest;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public record AccountBalanceRequest(@NonNull AccountId accountId, Hbar queryPayment, Hbar maxQueryPayment) implements QueryRequest
{
    public AccountBalanceRequest {
        Objects.requireNonNull(accountId, "accountId must not be null");
    }

    @NonNull
    public static AccountBalanceRequest of(@NonNull AccountId accountId) {
        return new AccountBalanceRequest(accountId, null, null);
    }

    @NonNull
    public static AccountBalanceRequest of(@NonNull String accountId) {
        Objects.requireNonNull(accountId, "accountId must not be null");
        return AccountBalanceRequest.of(AccountId.fromString((String)accountId));
    }
}

