/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base.protocol;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.openelements.hedera.base.protocol.TransactionRequest;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Objects;

public record AccountDeleteRequest(Hbar maxTransactionFee, Duration transactionValidDuration, @NonNull AccountId accountId, @Nullable AccountId transferFoundsToAccount) implements TransactionRequest
{
    public AccountDeleteRequest {
        Objects.requireNonNull(accountId, "accountId is required");
    }

    @NonNull
    public static AccountDeleteRequest of(@NonNull String accountId) {
        return AccountDeleteRequest.of(AccountId.fromString((String)accountId));
    }

    @NonNull
    public static AccountDeleteRequest of(@NonNull String accountId, @NonNull String transferFoundsToAccount) {
        Objects.requireNonNull(accountId, "accountId must not be null");
        AccountId realAccountId = AccountId.fromString((String)accountId);
        if (transferFoundsToAccount == null) {
            return AccountDeleteRequest.of(realAccountId);
        }
        AccountId realTransferFoundsToAccount = AccountId.fromString((String)transferFoundsToAccount);
        return AccountDeleteRequest.of(realAccountId, realTransferFoundsToAccount);
    }

    @NonNull
    public static AccountDeleteRequest of(@NonNull AccountId accountId) {
        return AccountDeleteRequest.of(accountId, null);
    }

    @NonNull
    public static AccountDeleteRequest of(@NonNull AccountId accountId, @Nullable AccountId transferFoundsToAccount) {
        return new AccountDeleteRequest(DEFAULT_MAX_TRANSACTION_FEE, DEFAULT_TRANSACTION_VALID_DURATION, accountId, transferFoundsToAccount);
    }
}

