/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base.protocol;

import com.hedera.hashgraph.sdk.Hbar;
import com.openelements.hedera.base.protocol.TransactionRequest;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public record FileCreateRequest(Hbar maxTransactionFee, Duration transactionValidDuration, @NonNull byte[] contents, @Nullable Instant expirationTime, String fileMemo) implements TransactionRequest
{
    private static final String DEFAULT_FILE_MEMO = "";
    public static final int FILE_CREATE_MAX_SIZE = 2048;
    public static final int FILE_MAX_SIZE = 1024000;

    public FileCreateRequest {
        Objects.requireNonNull(contents, "File contents are required");
        if (contents.length > 2048) {
            throw new IllegalArgumentException("File contents must be less than 2048 bytes");
        }
    }

    public static FileCreateRequest of(@NonNull byte[] contents) {
        return new FileCreateRequest(DEFAULT_MAX_TRANSACTION_FEE, DEFAULT_TRANSACTION_VALID_DURATION, contents, null, DEFAULT_FILE_MEMO);
    }

    public static FileCreateRequest of(@NonNull byte[] contents, @NonNull Instant expirationTime) {
        return new FileCreateRequest(DEFAULT_MAX_TRANSACTION_FEE, DEFAULT_TRANSACTION_VALID_DURATION, contents, expirationTime, DEFAULT_FILE_MEMO);
    }
}

