/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base.protocol;

import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.TokenId;
import com.openelements.hedera.base.protocol.TransactionRequest;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public record TokenMintRequest(Hbar maxTransactionFee, Duration transactionValidDuration, @NonNull TokenId tokenId, @NonNull PrivateKey supplyKey, @Nullable Long amount, @NonNull List<byte[]> metadata) implements TransactionRequest
{
    static int MAX_METADATA_SIZE = 100;

    public TokenMintRequest {
        Objects.requireNonNull(tokenId, "tokenId must not be null");
        Objects.requireNonNull(supplyKey, "supplyKey must not be null");
        Objects.requireNonNull(metadata, "metadata must not be null");
        if (amount != null && amount <= 0L) {
            throw new IllegalArgumentException("amount must be greater than 0");
        }
        metadata.forEach(m -> {
            if (((byte[])m).length > MAX_METADATA_SIZE) {
                throw new IllegalArgumentException("each metadata entry must be less than " + MAX_METADATA_SIZE + " bytes");
            }
        });
    }

    public static TokenMintRequest of(@NonNull TokenId tokenId, @NonNull PrivateKey supplyKey) {
        return new TokenMintRequest(TransactionRequest.DEFAULT_MAX_TRANSACTION_FEE, TransactionRequest.DEFAULT_TRANSACTION_VALID_DURATION, tokenId, supplyKey, null, List.of());
    }

    public static TokenMintRequest of(@NonNull TokenId tokenId, @NonNull PrivateKey supplyKey, long amount) {
        return new TokenMintRequest(TransactionRequest.DEFAULT_MAX_TRANSACTION_FEE, TransactionRequest.DEFAULT_TRANSACTION_VALID_DURATION, tokenId, supplyKey, amount, List.of());
    }

    public static TokenMintRequest of(@NonNull TokenId tokenId, @NonNull PrivateKey supplyKey, @NonNull String metadata) {
        Objects.requireNonNull(metadata, "metadata must not be null");
        return new TokenMintRequest(TransactionRequest.DEFAULT_MAX_TRANSACTION_FEE, TransactionRequest.DEFAULT_TRANSACTION_VALID_DURATION, tokenId, supplyKey, null, List.of(metadata.getBytes(StandardCharsets.UTF_8)));
    }

    public static TokenMintRequest of(@NonNull TokenId tokenId, @NonNull PrivateKey supplyKey, @NonNull List<String> metadata) {
        Objects.requireNonNull(metadata, "metadata must not be null");
        List<byte[]> metadataBytes = metadata.stream().map(m -> m.getBytes(StandardCharsets.UTF_8)).toList();
        return new TokenMintRequest(TransactionRequest.DEFAULT_MAX_TRANSACTION_FEE, TransactionRequest.DEFAULT_TRANSACTION_VALID_DURATION, tokenId, supplyKey, null, metadataBytes);
    }
}

