/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.spring.implementation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hedera.hashgraph.sdk.ContractId;
import com.openelements.hedera.base.ContractVerificationClient;
import com.openelements.hedera.base.ContractVerificationState;
import com.openelements.hedera.base.HederaException;
import com.openelements.hedera.base.implementation.HederaNetwork;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestClient;

public class ContractVerificationClientImplementation
implements ContractVerificationClient {
    private static final String CONTRACT_VERIFICATION_URL = "https://server-verify.hashscan.io";
    private final HederaNetwork hederaNetwork;
    private final ObjectMapper objectMapper;
    private final RestClient restClient;

    public ContractVerificationClientImplementation(@NonNull HederaNetwork hederaNetwork) {
        this.hederaNetwork = Objects.requireNonNull(hederaNetwork, "hederaNetwork must not be null");
        this.objectMapper = new ObjectMapper();
        this.restClient = RestClient.create();
    }

    @NonNull
    private String getChainId() throws HederaException {
        if (this.hederaNetwork == HederaNetwork.CUSTOM) {
            throw new HederaException("A custom Hedera network is not supported for smart contract verification. Please use MainNet, TestNet or PreviewNet.");
        }
        return "" + this.hederaNetwork.getChainId();
    }

    private void handleError(@NonNull HttpRequest request, @NonNull ClientHttpResponse response) throws IOException {
        String error;
        Objects.requireNonNull(response, "response must not be null");
        try {
            String body = new String(response.getBody().readAllBytes(), StandardCharsets.UTF_8);
            try {
                JsonNode messageNode;
                JsonNode rootNode = this.objectMapper.readTree(body);
                JsonNode errorNode = rootNode.get("error");
                error = errorNode != null ? errorNode.asText() : ((messageNode = rootNode.get("message")) != null ? messageNode.asText() : body);
            }
            catch (Exception e) {
                throw new IOException("Error parsing body as JSON: " + body, e);
            }
        }
        catch (Exception e) {
            throw new IOException("Error (" + String.valueOf(response.getStatusCode()) + "): " + response.getStatusText());
        }
        throw new IOException("Error (" + String.valueOf(response.getStatusCode()) + "): " + error);
    }

    public ContractVerificationState verify(@NonNull ContractId contractId, @NonNull String contractName, @NonNull Map<String, String> files) throws HederaException {
        Objects.requireNonNull(contractId, "contractId must not be null");
        Objects.requireNonNull(contractName, "contractName must not be null");
        Objects.requireNonNull(files, "files must not be null");
        ContractVerificationState state = this.checkVerification(contractId);
        if (state != ContractVerificationState.NONE) {
            throw new IllegalStateException("Contract is already verified");
        }
        VerifyRequest verifyRequest = new VerifyRequest(contractId.toSolidityAddress(), this.getChainId(), "", "", files);
        try {
            String resultBody = (String)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri("https://server-verify.hashscan.io/verify", new Object[0])).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body((Object)verifyRequest).retrieve().onStatus(HttpStatusCode::is4xxClientError, (request, response) -> this.handleError(request, response)).body(String.class);
            JsonNode rootNode = this.objectMapper.readTree(resultBody);
            JsonNode resultNode = rootNode.get("result");
            if (resultNode != null) {
                if (resultNode.isArray()) {
                    List results = StreamSupport.stream(resultNode.spliterator(), false).toList();
                    if (results.size() != 1) {
                        throw new RuntimeException("Expected exactly one result, got " + results.size());
                    }
                    JsonNode result = (JsonNode)results.get(0);
                    JsonNode statusNode = result.get("status");
                    if (statusNode != null) {
                        if (statusNode.asText().equals("perfect")) {
                            return ContractVerificationState.FULL;
                        }
                        if (statusNode.asText().equals("false")) {
                            return ContractVerificationState.NONE;
                        }
                        throw new RuntimeException("Status is not success: " + statusNode.asText());
                    }
                    throw new RuntimeException("No status in response");
                }
                throw new RuntimeException("Result is not an array");
            }
            throw new RuntimeException("No result in response");
        }
        catch (Exception e) {
            throw new HederaException("Error verification step", (Throwable)e);
        }
    }

    public ContractVerificationState checkVerification(@NonNull ContractId contractId) throws HederaException {
        Objects.requireNonNull(contractId, "contractId must not be null");
        String uri = "https://server-verify.hashscan.io/check-by-addresses?addresses=" + contractId.toSolidityAddress() + "&chainIds=" + this.getChainId();
        try {
            String resultBody = (String)this.restClient.get().uri(uri, new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().onStatus(HttpStatusCode::is4xxClientError, (request, response) -> this.handleError(request, response)).body(String.class);
            JsonNode rootNode = this.objectMapper.readTree(resultBody);
            if (rootNode.isArray()) {
                List results = StreamSupport.stream(rootNode.spliterator(), false).toList();
                if (results.size() != 1) {
                    throw new RuntimeException("Expected exactly one result, got " + results.size());
                }
                JsonNode result = (JsonNode)results.get(0);
                JsonNode statusNode = result.get("status");
                if (statusNode != null) {
                    if (statusNode.asText().equals("perfect")) {
                        return ContractVerificationState.FULL;
                    }
                    if (statusNode.asText().equals("false")) {
                        return ContractVerificationState.NONE;
                    }
                    throw new RuntimeException("Status is not success: " + statusNode.asText());
                }
                throw new RuntimeException("No status in response");
            }
            throw new RuntimeException("Result is not an array");
        }
        catch (Exception e) {
            throw new HederaException("Error verification step", (Throwable)e);
        }
    }

    public boolean checkVerification(@NonNull ContractId contractId, @NonNull String fileName, @NonNull String fileContent) throws HederaException {
        Objects.requireNonNull(contractId, "contractId must not be null");
        Objects.requireNonNull(fileName, "fileName must not be null");
        Objects.requireNonNull(fileContent, "fileContent must not be null");
        ContractVerificationState state = this.checkVerification(contractId);
        if (state != ContractVerificationState.FULL) {
            throw new IllegalStateException("Contract is not verified");
        }
        String uri = "https://server-verify.hashscan.io/files/" + this.getChainId() + "/" + contractId.toSolidityAddress();
        try {
            String resultBody = (String)this.restClient.get().uri(uri, new Object[0]).header("accept", new String[]{"application/json"}).retrieve().onStatus(HttpStatusCode::is4xxClientError, (request, response) -> this.handleError(request, response)).body(String.class);
            JsonNode rootNode = this.objectMapper.readTree(resultBody);
            if (rootNode.isArray()) {
                List<JsonNode> results = StreamSupport.stream(rootNode.spliterator(), false).filter(node -> node.get("name").asText().equals(fileName)).toList();
                if (results.size() != 1) {
                    throw new RuntimeException("Expected exactly one result, got " + results.size());
                }
                JsonNode result = results.get(0);
                JsonNode contentNode = result.get("content");
                if (contentNode != null) {
                    return contentNode.asText().equals(fileContent);
                }
                throw new RuntimeException("No content in response");
            }
            throw new RuntimeException("Result is not an array");
        }
        catch (Exception e) {
            throw new HederaException("Error verification step", (Throwable)e);
        }
    }

    private record VerifyRequest(String address, String chain, String creatorTxHash, String chosenContract, Map<String, String> files) {
    }
}

