/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.spring.implementation;

import com.hedera.hashgraph.sdk.ContractId;
import com.openelements.hedera.base.ContractVerificationClient;
import com.openelements.hedera.base.ContractVerificationState;
import com.openelements.hedera.base.HederaException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractVerificationUtility {
    private static final Logger log = LoggerFactory.getLogger(ContractVerificationUtility.class);
    private final ContractVerificationClient verificationClient;

    public ContractVerificationUtility(@NonNull ContractVerificationClient verificationClient) {
        this.verificationClient = Objects.requireNonNull(verificationClient, "verificationClient must not be null");
    }

    void doFullVerification(ContractId contractId, String contractName, String contractSource, String contractMetadata) throws HederaException {
        this.doFullVerification(contractId, contractName, Map.of(contractName + ".sol", contractSource, "metadata.json", contractMetadata));
    }

    void doFullVerification(ContractId contractId, String contractName, Map<String, String> files) throws HederaException {
        ContractVerificationState state = this.verificationClient.checkVerification(contractId);
        if (state == ContractVerificationState.FULL) {
            log.debug("Contract {} is already fully verified", (Object)contractId);
        } else {
            log.debug("Contract {} is not fully verified, will start verification", (Object)contractId);
            ContractVerificationState newState = this.verificationClient.verify(contractId, contractName, files);
            if (newState == ContractVerificationState.FULL) {
                log.debug("Contract {} is now fully verified", (Object)contractId);
            } else {
                throw new IllegalStateException("Contract " + String.valueOf(contractId) + " is not fully verified, state is " + String.valueOf(newState));
            }
        }
        for (Map.Entry<String, String> entry : files.entrySet()) {
            if (this.verificationClient.checkVerification(contractId, entry.getKey(), entry.getValue())) continue;
            throw new IllegalStateException("file " + entry.getKey() + " is invalid");
        }
    }
}

