/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.spring.implementation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TokenId;
import com.openelements.hedera.base.HederaException;
import com.openelements.hedera.base.Nft;
import com.openelements.hedera.base.mirrornode.MirrorNodeClient;
import com.openelements.hedera.base.mirrornode.TransactionInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriBuilder;

public class MirrorNodeClientImpl
implements MirrorNodeClient {
    private final ObjectMapper objectMapper;
    private final RestClient restClient;
    private final String mirrorNodeEndpointScheme = "https";
    private final String mirrorNodeEndpointHost;
    private final String mirrorNodeEndpointPort;

    public MirrorNodeClientImpl(@NonNull Client client) {
        Objects.requireNonNull(client, "client must not be null");
        List mirrorNetwork = client.getMirrorNetwork();
        if (mirrorNetwork.isEmpty()) {
            throw new IllegalArgumentException("No mirror network is configured");
        }
        this.mirrorNodeEndpointHost = ((String)mirrorNetwork.get(0)).split("\\:")[0];
        this.mirrorNodeEndpointPort = ((String)mirrorNetwork.get(0)).split("\\:")[1];
        this.objectMapper = new ObjectMapper();
        this.restClient = RestClient.create();
    }

    public List<Nft> queryNftsByAccount(@NonNull AccountId accountId) throws HederaException {
        Objects.requireNonNull(accountId, "accountId must not be null");
        JsonNode jsonNode = this.doGetCall("/api/v1/accounts/" + String.valueOf(accountId) + "/nfts");
        return this.jsonNodeToNftList(jsonNode);
    }

    public List<Nft> queryNftsByAccountAndTokenId(@NonNull AccountId accountId, @NonNull TokenId tokenId) throws HederaException {
        Objects.requireNonNull(accountId, "accountId must not be null");
        Objects.requireNonNull(tokenId, "tokenId must not be null");
        JsonNode jsonNode = this.doGetCall("/api/v1/tokens/" + String.valueOf(tokenId) + "/nfts", Map.of("account.id", accountId));
        return this.jsonNodeToNftList(jsonNode);
    }

    public List<Nft> queryNftsByTokenId(@NonNull TokenId tokenId) throws HederaException {
        Objects.requireNonNull(tokenId, "tokenId must not be null");
        JsonNode jsonNode = this.doGetCall("/api/v1/tokens/" + String.valueOf(tokenId) + "/nfts");
        return this.jsonNodeToNftList(jsonNode);
    }

    public Optional<Nft> queryNftsByTokenIdAndSerial(@NonNull TokenId tokenId, @NonNull long serialNumber) throws HederaException {
        Objects.requireNonNull(tokenId, "tokenId must not be null");
        if (serialNumber <= 0L) {
            throw new IllegalArgumentException("serialNumber must be positive");
        }
        JsonNode jsonNode = this.doGetCall("/api/v1/tokens/" + String.valueOf(tokenId) + "/nfts/" + serialNumber);
        return this.jsonNodeToOptionalNft(jsonNode);
    }

    public Optional<Nft> queryNftsByAccountAndTokenIdAndSerial(@NonNull AccountId accountId, @NonNull TokenId tokenId, long serialNumber) throws HederaException {
        Objects.requireNonNull(accountId, "accountId must not be null");
        return this.queryNftsByTokenIdAndSerial(tokenId, serialNumber).filter(nft -> Objects.equals(nft.owner(), accountId));
    }

    public Optional<TransactionInfo> queryTransaction(@NonNull String transactionId) throws HederaException {
        Objects.requireNonNull(transactionId, "transactionId must not be null");
        JsonNode jsonNode = this.doGetCall("/api/v1/transactions/" + transactionId);
        if (jsonNode == null || !jsonNode.fieldNames().hasNext()) {
            return Optional.empty();
        }
        return Optional.of(new TransactionInfo(transactionId));
    }

    private JsonNode doGetCall(String path, Map<String, ?> params) throws HederaException {
        return this.doGetCall((UriBuilder builder) -> {
            UriBuilder uriBuilder = builder.path(path);
            for (Map.Entry entry : params.entrySet()) {
                uriBuilder = uriBuilder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
            }
            return uriBuilder.build(new Object[0]);
        });
    }

    private JsonNode doGetCall(String path) throws HederaException {
        return this.doGetCall((UriBuilder builder) -> builder.path(path).build(new Object[0]));
    }

    private JsonNode doGetCall(Function<UriBuilder, URI> uriFunction) throws HederaException {
        ResponseEntity responseEntity = this.restClient.get().uri(uriBuilder -> {
            UriBuilder withEndpoint = uriBuilder.scheme("https").host(this.mirrorNodeEndpointHost).port(this.mirrorNodeEndpointPort);
            return (URI)uriFunction.apply(withEndpoint);
        }).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().onStatus(HttpStatusCode::is4xxClientError, (request, response) -> {
            if (!HttpStatus.NOT_FOUND.equals((Object)response.getStatusCode())) {
                throw new RuntimeException("Client error: " + response.getStatusText());
            }
        }).toEntity(String.class);
        String body = (String)responseEntity.getBody();
        try {
            if (HttpStatus.NOT_FOUND.equals((Object)responseEntity.getStatusCode())) {
                return this.objectMapper.readTree("{}");
            }
            return this.objectMapper.readTree(body);
        }
        catch (JsonProcessingException e) {
            throw new HederaException("Error parsing body as JSON: " + body, (Throwable)e);
        }
    }

    private List<Nft> jsonNodeToNftList(JsonNode rootNode) {
        if (rootNode == null || !rootNode.fieldNames().hasNext()) {
            return List.of();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(rootNode.get("nfts").iterator(), 16), false).map(nftNode -> {
            try {
                return this.jsonNodeToNft((JsonNode)nftNode);
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing NFT from JSON '" + String.valueOf(nftNode) + "'", e);
            }
        }).toList();
    }

    private Optional<Nft> jsonNodeToOptionalNft(JsonNode jsonNode) throws HederaException {
        if (jsonNode == null || !jsonNode.fieldNames().hasNext()) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.jsonNodeToNft(jsonNode));
        }
        catch (Exception e) {
            throw new HederaException("Error parsing NFT from JSON '" + String.valueOf(jsonNode) + "'", (Throwable)e);
        }
    }

    private Nft jsonNodeToNft(JsonNode jsonNode) throws IOException {
        try {
            TokenId parsedTokenId = TokenId.fromString((String)jsonNode.get("token_id").asText());
            AccountId account = AccountId.fromString((String)jsonNode.get("account_id").asText());
            long serial = jsonNode.get("serial_number").asLong();
            byte[] metadata = jsonNode.get("metadata").binaryValue();
            return new Nft(parsedTokenId, serial, account, metadata);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing NFT from JSON '" + String.valueOf(jsonNode) + "'", e);
        }
    }
}

