package com.licorize.api.client.constant;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author Federico Soldani - fsoldani@open-lab.com
 */
public final class LicorizeClientConstants {

  /**
   * The Constant APP_CONSTANTS_FILE.
   */
  public static final String APP_CONSTANTS_FILE = "LicorizeClientConstants.properties";

  /**
   * The static logger.
   */
  private static final Logger LOG = Logger.getLogger(LicorizeClientConstants.class.getCanonicalName());

  /**
   * The Constant applicationConstants.
   */
  private static final Properties applicationConstants = new Properties();

  static {
    try {
      applicationConstants.load(
              LicorizeClientConstants.class.getResourceAsStream(APP_CONSTANTS_FILE));
    } catch (IOException e) {
      LOG.log(Level.SEVERE, "An error occurred while loading properties.", e);
    }
  }

  /**
   * The Constant OAUTH_VERSION.
   */
  public static final String OAUTH_VERSION = getProperty("com.licorize.api.client.oauthVersion");

  /**
   * The Constant CLIENT_DEFAULT_IMPL.
   */
  public static final String CLIENT_DEFAULT_IMPL = getProperty("com.licorize.api.client.defaultImpl");

  /**
   * The Constant CONNECT_TIMEOUT.
   */
  public static final int CONNECT_TIMEOUT = getIntProperty("com.licorize.api.client.connectTimeout");

  /** The Constant CONTENT_ENCODING. */
  public static final String CONTENT_ENCODING = getProperty("com.licorize.api.client.encoding");

  /**
   * Instantiates a new application constants.
   */
  private LicorizeClientConstants() {
  }

  /**
   * Get property as int.
   */
  public static String getProperty(String key) {
    return applicationConstants.getProperty(key);
  }

  /**
   * Get property as int.
   */
  public static int getIntProperty(String key) {
    String property = applicationConstants.getProperty(key);

    if (isNullOrEmpty(property)) {
      return 0;
    } else {
      return Integer.parseInt(property);
    }
  }

  /**
   * Get property as boolean.
   */
  public static boolean getBooleanProperty(String key) {
    String property = applicationConstants.getProperty(key);

    if (isNullOrEmpty(property)) {
      return false;
    } else {
      return Boolean.parseBoolean(property);
    }
  }

  /**
   * Get property as double.
   */
  public static double getDoubleProperty(String key) {
    String property = applicationConstants.getProperty(key);

    if (isNullOrEmpty(property)) {
      return 0;
    } else {
      return Double.parseDouble(property);
    }
  }

  /**
   * Get property as long.
   */
  public static long getLongProperty(String key) {
    String property = applicationConstants.getProperty(key);

    if (isNullOrEmpty(property)) {
      return 0;
    } else {
      return Long.parseLong(property);
    }
  }

  /**
   * Get property as long.
   */
  private static boolean isNullOrEmpty(String s) {
    return ((s == null) || s.length() == 0);
  }
}
