package com.licorize.api.client.impl;

import com.licorize.api.client.LicorizeApiResponse;
import net.sf.json.JSONObject;

/**
 * @author Federico Soldani - fsoldani@open-lab.com
 */
public class LicorizeApiResponseImpl implements LicorizeApiResponse {

  private boolean success;
  private String responseString;
  private JSONObject responseObject;
  private String message;
  private String error;

  @Override
  public boolean isSuccess() {
    return this.success;
  }

  @Override
  public String getResponseString() {
    return this.responseString;
  }

  @Override
  public JSONObject getResponseObject() {
    if(null == this.responseObject) {
      this.responseObject = JSONObject.fromObject(this.responseString);
    }
    return this.responseObject;
  }

  @Override

  public String getMessage() {
    return this.message;
  }

  @Override
  public String getError() {
    return this.error;
  }

  public void setSuccess(boolean success) {
    this.success = success;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public void setError(String error) {
    this.error = error;
  }

  public void setResponseString(String responseString) {
    this.responseString = responseString;
  }

  protected void setResponseObject(JSONObject responseObject) {
    this.responseObject = responseObject;
  }
}