package com.licorize.api.client.oauth;

import org.scribe.builder.ServiceBuilder;
import org.scribe.oauth.OAuthService;

/**
 * A factory for creating LicorizeOAuthService objects.
 *
 * @author Federico Soldani - fsoldani@open-lab.com
 */
public class LicorizeOauthServiceFactory {
  /**
   * The instance.
   */
  private static LicorizeOauthServiceFactory instance;

  /**
   * Instantiates a new Licorize o auth service factory.
   */
  private LicorizeOauthServiceFactory() {
  }

  /**
   * Gets the single instance of LicorizeOauthServiceFactory.
   *
   * @return single instance of LicorizeOauthServiceFactory
   */
  public static synchronized LicorizeOauthServiceFactory getInstance() {
    if (instance == null) {
      instance = new LicorizeOauthServiceFactory();
    }

    return instance;
  }

  /**
   * Creates a new LicorizeOAuthService object.
   *
   * @param consumerKey    the consumer key
   * @param consumerSecret the consumer secret
   * @return the Licorize o auth service
   */
  public LicorizeOauthService createLicorizeOAuthService(String consumerKey, String consumerSecret) {
    OAuthService service = new ServiceBuilder()
            .provider(LicorizeApi.class)
            .apiKey(consumerKey)
            .apiSecret(consumerSecret)
            .build();
    return createLicorizeOAuthService(service);
  }

  /**
   * Creates a new LicorizeOauthService object.
   *
   * @param oauthService the api consumer
   * @return the Licorize o auth service
   */
  public LicorizeOauthService createLicorizeOAuthService(OAuthService oauthService) {
    return new LicorizeOauthServiceImpl(oauthService);
  }

}