package com.licorize.api.client.oauth;

import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

/**
 * @author Federico Soldani - fsoldani@open-lab.com
 */
public class LicorizeOauthServiceImpl implements LicorizeOauthService {

  private final OAuthService oauthService;

  /**
   * Constructs ...
   *
   * @param oauthService
   */
  LicorizeOauthServiceImpl(OAuthService oauthService) {
    this.oauthService = oauthService;
  }

  @Override
  public Token getRequestToken() {
    return this.oauthService.getRequestToken();
  }

  @Override
  public Token getAccessToken(Token requestToken) {
    return this.oauthService.getAccessToken(requestToken, new Verifier(""));
  }
}
