/*
 * Decompiled with CFR 0.152.
 */
package com.licorize.api.client.constant;

import com.licorize.api.client.constant.LicorizeClientConstants;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LicorizeApiUrls {
    public static final String API_URLS_FILE = "LicorizeApiUrls.properties";
    private static final Logger LOG = Logger.getLogger(LicorizeApiUrls.class.getCanonicalName());
    private static final Properties licorizeApiUrls = new Properties();
    public static final String GET_STRIPS_LIST;
    public static final String GET_STRIP;
    public static final String UPDATE_STRIP;
    public static final String REMOVE_STRIP;
    public static final String CHANGE_STRIP_TYPE;
    public static final String GET_PROJECTS_LIST;
    public static final String UPDATE_PROJECT;
    public static final String GET_PROJECT;
    public static final String GET_PROJECT_MEMBERS;
    public static final String REMOVE_PROJECT;
    public static final String GET_TAGS_LIST;
    public static final String GET_USER;
    public static final String GET_PUBLIC_USER;
    public static final String REMIND_ME_LATER;
    public static final String LICORIZE_OAUTH_REQUEST_TOKEN_URL;
    public static final String LICORIZE_OAUTH_AUTHORIZE_URL;
    public static final String LICORIZE_OAUTH_AUTHORIZE_CALL_URL;
    public static final String LICORIZE_OAUTH_ACCESS_TOKEN_URL;
    public static final String LICORIZE_OAUTH_INVALIDATE_TOKEN_URL;

    private LicorizeApiUrls() {
    }

    static {
        try {
            licorizeApiUrls.load(LicorizeApiUrls.class.getResourceAsStream(API_URLS_FILE));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "An error occurred while loading urls.", e);
        }
        GET_STRIPS_LIST = licorizeApiUrls.getProperty("com.licorize.api.client.getStripsList");
        GET_STRIP = licorizeApiUrls.getProperty("com.licorize.api.client.getStrip");
        UPDATE_STRIP = licorizeApiUrls.getProperty("com.licorize.api.client.updateStrip");
        REMOVE_STRIP = licorizeApiUrls.getProperty("com.licorize.api.client.removeStrip");
        CHANGE_STRIP_TYPE = licorizeApiUrls.getProperty("com.licorize.api.client.changeStripType");
        GET_PROJECTS_LIST = licorizeApiUrls.getProperty("com.licorize.api.client.getProjectsList");
        UPDATE_PROJECT = licorizeApiUrls.getProperty("com.licorize.api.client.updateProject");
        GET_PROJECT = licorizeApiUrls.getProperty("com.licorize.api.client.getProject");
        GET_PROJECT_MEMBERS = licorizeApiUrls.getProperty("com.licorize.api.client.getProjectMembers");
        REMOVE_PROJECT = licorizeApiUrls.getProperty("com.licorize.api.client.removeProject");
        GET_TAGS_LIST = licorizeApiUrls.getProperty("com.licorize.api.client.getTagsList");
        GET_USER = licorizeApiUrls.getProperty("com.licorize.api.client.getUser");
        GET_PUBLIC_USER = licorizeApiUrls.getProperty("com.licorize.api.client.getPublicUser");
        REMIND_ME_LATER = licorizeApiUrls.getProperty("com.licorize.api.client.remindMeLater");
        LICORIZE_OAUTH_REQUEST_TOKEN_URL = licorizeApiUrls.getProperty("com.licorize.api.client.oauth.requestToken");
        LICORIZE_OAUTH_AUTHORIZE_URL = licorizeApiUrls.getProperty("com.licorize.api.client.oauth.authorize");
        LICORIZE_OAUTH_AUTHORIZE_CALL_URL = licorizeApiUrls.getProperty("com.licorize.api.client.oauth.authorizeUrl");
        LICORIZE_OAUTH_ACCESS_TOKEN_URL = licorizeApiUrls.getProperty("com.licorize.api.client.oauth.accessToken");
        LICORIZE_OAUTH_INVALIDATE_TOKEN_URL = licorizeApiUrls.getProperty("com.licorize.api.client.oauth.invalidateToken");
    }

    public static class LicorizeApiUrlBuilder {
        private static final char API_URLS_PLACEHOLDER_START = '{';
        private static final char API_URLS_PLACEHOLDER_END = '}';
        private static final String QUERY_PARAMETERS_PLACEHOLDER = "queryParameters";
        private String urlFormat;
        private Map<String, Collection<String>> parametersMap = new HashMap<String, Collection<String>>();
        private Map<String, String> fieldsMap = new HashMap<String, String>();

        public LicorizeApiUrlBuilder(String urlFormat) {
            this.urlFormat = urlFormat;
        }

        public LicorizeApiUrlBuilder withParameter(String name, String value) {
            if (value != null && value.length() > 0) {
                this.parametersMap.put(name, Collections.singleton(LicorizeApiUrlBuilder.encodeUrl(value)));
            }
            return this;
        }

        public LicorizeApiUrlBuilder withParameters(String name, Collection<String> values) {
            ArrayList<String> encodedValues = new ArrayList<String>(values.size());
            for (String value : values) {
                encodedValues.add(LicorizeApiUrlBuilder.encodeUrl(value));
            }
            this.parametersMap.put(name, encodedValues);
            return this;
        }

        public LicorizeApiUrlBuilder withEmptyField(String name) {
            this.fieldsMap.put(name, "");
            return this;
        }

        public LicorizeApiUrlBuilder withField(String name, String value) {
            this.withField(name, value, false);
            return this;
        }

        public LicorizeApiUrlBuilder withField(String name, String value, boolean escape) {
            if (escape) {
                this.fieldsMap.put(name, LicorizeApiUrlBuilder.encodeUrl(value));
            } else {
                this.fieldsMap.put(name, value);
            }
            return this;
        }

        public String buildUrl() {
            StringBuilder urlBuilder = new StringBuilder();
            StringBuilder placeHolderBuilder = new StringBuilder();
            boolean placeHolderFlag = false;
            for (int i = 0; i < this.urlFormat.length(); ++i) {
                if (this.urlFormat.charAt(i) == '{') {
                    placeHolderBuilder = new StringBuilder();
                    placeHolderFlag = true;
                    continue;
                }
                if (placeHolderFlag && this.urlFormat.charAt(i) == '}') {
                    String placeHolder = placeHolderBuilder.toString();
                    if (this.fieldsMap.containsKey(placeHolder)) {
                        urlBuilder.append(this.fieldsMap.get(placeHolder));
                    } else if (QUERY_PARAMETERS_PLACEHOLDER.equals(placeHolder)) {
                        StringBuilder builder = new StringBuilder();
                        if (!this.parametersMap.isEmpty()) {
                            builder.append("?");
                            Iterator<String> iter = this.parametersMap.keySet().iterator();
                            while (iter.hasNext()) {
                                String name = iter.next();
                                Collection<String> parameterValues = this.parametersMap.get(name);
                                Iterator<String> iterParam = parameterValues.iterator();
                                while (iterParam.hasNext()) {
                                    builder.append(name);
                                    builder.append("=");
                                    builder.append(iterParam.next());
                                    if (!iterParam.hasNext()) continue;
                                    builder.append("&");
                                }
                                if (!iter.hasNext()) continue;
                                builder.append("&");
                            }
                        }
                        urlBuilder.append(builder.toString());
                    } else {
                        urlBuilder.append('{');
                        urlBuilder.append(placeHolder);
                        urlBuilder.append('}');
                    }
                    placeHolderFlag = false;
                    continue;
                }
                if (placeHolderFlag) {
                    placeHolderBuilder.append(this.urlFormat.charAt(i));
                    continue;
                }
                urlBuilder.append(this.urlFormat.charAt(i));
            }
            return urlBuilder.toString();
        }

        private static String encodeUrl(String original) {
            try {
                return URLEncoder.encode(original, LicorizeClientConstants.CONTENT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                return original;
            }
        }
    }
}

