/*
 * Decompiled with CFR 0.152.
 */
package com.licorize.api.client.constant;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LicorizeClientConstants {
    public static final String APP_CONSTANTS_FILE = "LicorizeClientConstants.properties";
    private static final Logger LOG = Logger.getLogger(LicorizeClientConstants.class.getCanonicalName());
    private static final Properties applicationConstants = new Properties();
    public static final String OAUTH_VERSION;
    public static final String CLIENT_DEFAULT_IMPL;
    public static final int CONNECT_TIMEOUT;
    public static final String CONTENT_ENCODING;

    private LicorizeClientConstants() {
    }

    public static String getProperty(String key) {
        return applicationConstants.getProperty(key);
    }

    public static int getIntProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (LicorizeClientConstants.isNullOrEmpty(property)) {
            return 0;
        }
        return Integer.parseInt(property);
    }

    public static boolean getBooleanProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (LicorizeClientConstants.isNullOrEmpty(property)) {
            return false;
        }
        return Boolean.parseBoolean(property);
    }

    public static double getDoubleProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (LicorizeClientConstants.isNullOrEmpty(property)) {
            return 0.0;
        }
        return Double.parseDouble(property);
    }

    public static long getLongProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (LicorizeClientConstants.isNullOrEmpty(property)) {
            return 0L;
        }
        return Long.parseLong(property);
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    static {
        try {
            applicationConstants.load(LicorizeClientConstants.class.getResourceAsStream(APP_CONSTANTS_FILE));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "An error occurred while loading properties.", e);
        }
        OAUTH_VERSION = LicorizeClientConstants.getProperty("com.licorize.api.client.oauthVersion");
        CLIENT_DEFAULT_IMPL = LicorizeClientConstants.getProperty("com.licorize.api.client.defaultImpl");
        CONNECT_TIMEOUT = LicorizeClientConstants.getIntProperty("com.licorize.api.client.connectTimeout");
        CONTENT_ENCODING = LicorizeClientConstants.getProperty("com.licorize.api.client.encoding");
    }
}

