/*
 * Decompiled with CFR 0.152.
 */
package com.licorize.api.client;

import com.licorize.api.client.LicorizeClient;
import com.licorize.api.client.LicorizeClientException;
import com.licorize.api.client.constant.LicorizeClientConstants;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.scribe.model.Token;

public class LicorizeClientFactory
implements Serializable {
    private static final Map<Token, LicorizeClientFactory> factoriesMap = new ConcurrentHashMap<Token, LicorizeClientFactory>();
    private static final long serialVersionUID = -8786350214116968924L;
    private Token apiConsumer;
    private Constructor<? extends LicorizeClient> defaultClientImpl;

    private LicorizeClientFactory(Token apiConsumer) {
        this.apiConsumer = apiConsumer;
    }

    public static LicorizeClientFactory newInstance(String consumerKey, String consumerSecret) {
        return LicorizeClientFactory.newInstance(new Token(consumerKey, consumerSecret));
    }

    public static synchronized LicorizeClientFactory newInstance(Token apiConsumer) {
        LicorizeClientFactory.validateConsumerKey(apiConsumer);
        LicorizeClientFactory factory = factoriesMap.get(apiConsumer);
        if (factory == null) {
            factory = new LicorizeClientFactory(apiConsumer);
            factoriesMap.put(apiConsumer, factory);
        }
        return factory;
    }

    public LicorizeClient createLicorizeClient(Token accessToken) {
        this.validateAccessToken(accessToken);
        try {
            if (this.defaultClientImpl == null) {
                Class<?> clazz = Class.forName(LicorizeClientConstants.CLIENT_DEFAULT_IMPL);
                this.defaultClientImpl = clazz.getConstructor(String.class, String.class);
            }
            LicorizeClient client = this.defaultClientImpl.newInstance(this.apiConsumer.getToken(), this.apiConsumer.getSecret());
            client.setAccessToken(accessToken);
            return client;
        }
        catch (Exception e) {
            throw new LicorizeClientException(e);
        }
    }

    public LicorizeClient createLicorizeClient(Class<? extends LicorizeClient> implClass, Token accessToken) {
        this.validateAccessToken(accessToken);
        try {
            LicorizeClient client = implClass.getConstructor(String.class, String.class).newInstance(this.apiConsumer.getToken(), this.apiConsumer.getSecret());
            client.setAccessToken(accessToken);
            return client;
        }
        catch (Exception e) {
            throw new LicorizeClientException(e);
        }
    }

    private static void validateConsumerKey(Token apiConsumer) {
        if (apiConsumer == null) {
            throw new IllegalArgumentException("api consumer cannot be null.");
        }
        if (apiConsumer.getToken() == null || apiConsumer.getToken().length() == 0) {
            throw new IllegalArgumentException("consumer key cannot be null or empty.");
        }
        if (apiConsumer.getSecret() == null || apiConsumer.getSecret().length() == 0) {
            throw new IllegalArgumentException("consumer secret cannot be null or empty.");
        }
    }

    private void validateAccessToken(Token accessToken) {
        if (accessToken == null) {
            throw new IllegalArgumentException("access token cannot be null.");
        }
        if (accessToken.getToken() == null || accessToken.getToken().length() == 0) {
            throw new IllegalArgumentException("access token cannot be null or empty.");
        }
        if (accessToken.getSecret() == null || accessToken.getSecret().length() == 0) {
            throw new IllegalArgumentException("access token secret cannot be null or empty.");
        }
    }
}

