/*
 * Decompiled with CFR 0.152.
 */
package com.licorize.api.client.impl;

import com.licorize.api.client.LicorizeApiResponse;
import com.licorize.api.client.LicorizeClient;
import com.licorize.api.client.LicorizeClientException;
import com.licorize.api.client.Parameter;
import com.licorize.api.client.constant.LicorizeApiUrls;
import com.licorize.api.client.constant.LicorizeClientConstants;
import com.licorize.api.client.impl.LicorizeApiResponseImpl;
import com.licorize.api.client.oauth.LicorizeApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.scribe.builder.ServiceBuilder;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class LicorizeClientImpl
implements LicorizeClient {
    protected final Logger LOG = Logger.getLogger(this.getClass().getCanonicalName());
    private Token accessToken;
    private Token apiConsumer;

    public LicorizeClientImpl(String consumerKey, String consumerSecret) {
        this.apiConsumer = new Token(consumerKey, consumerSecret);
    }

    @Override
    public Token getRequestToken() {
        try {
            OAuthService service = this.buildService();
            return service.getRequestToken();
        }
        catch (Exception e) {
            throw new LicorizeClientException(e);
        }
    }

    @Override
    public Token getAccessToken(Token requestToken) {
        LicorizeClientImpl.validateRequestToken(requestToken);
        try {
            OAuthService service = this.buildService();
            this.accessToken = service.getAccessToken(requestToken, new Verifier(""));
            return this.accessToken;
        }
        catch (Exception e) {
            throw new LicorizeClientException(e);
        }
    }

    @Override
    public String getAuthenticationUrl(Token requestToken) {
        LicorizeClientImpl.validateRequestToken(requestToken);
        LicorizeApiUrls.LicorizeApiUrlBuilder builder = this.createLicorizeApiUrlBuilder(LicorizeApiUrls.LICORIZE_OAUTH_AUTHORIZE_CALL_URL);
        return builder.withParameter("REQUEST_TOKEN", requestToken.getToken()).buildUrl();
    }

    @Override
    public void setAccessToken(Token accessToken) {
        this.accessToken = accessToken;
    }

    @Override
    public LicorizeApiResponse getStripList() {
        return this.getStripList(null);
    }

    @Override
    public LicorizeApiResponse getStripList(List<Parameter<String, String>> parameters) {
        ArrayList<Parameter<String, String>> _parameters = new ArrayList<Parameter<String, String>>();
        if (parameters != null) {
            _parameters.addAll(parameters);
        }
        return this.readResponse(this.callOAuthApiMethod(LicorizeApiUrls.GET_STRIPS_LIST, parameters));
    }

    @Override
    public LicorizeApiResponse getStrip(int stripId) {
        this.assertPositiveNumber("strip ID", stripId);
        LicorizeApiUrls.LicorizeApiUrlBuilder builder = this.createLicorizeApiUrlBuilder(LicorizeApiUrls.GET_STRIP);
        String apiUrl = builder.withField("STRIP_ID", String.valueOf(stripId)).buildUrl();
        return this.readResponse(this.callOAuthApiMethod(apiUrl));
    }

    @Override
    public LicorizeApiResponse updateStrip(int stripId, List<Parameter<String, String>> parameters) {
        this.assertPositiveNumber("strip ID", stripId);
        ArrayList<Parameter<String, String>> _parameters = new ArrayList<Parameter<String, String>>();
        _parameters.add(new Parameter<String, Integer>("id", stripId));
        if (parameters != null) {
            _parameters.addAll(parameters);
        }
        return this.createStrip(_parameters);
    }

    @Override
    public LicorizeApiResponse createStrip(List<Parameter<String, String>> parameters) {
        ArrayList<Parameter<String, String>> _parameters = new ArrayList<Parameter<String, String>>();
        if (parameters != null) {
            _parameters.addAll(parameters);
        }
        return this.readResponse(this.callOAuthApiMethod(LicorizeApiUrls.UPDATE_STRIP, _parameters));
    }

    @Override
    public LicorizeApiResponse removeStrip(int stripId) {
        this.assertPositiveNumber("strip ID", stripId);
        LicorizeApiUrls.LicorizeApiUrlBuilder builder = this.createLicorizeApiUrlBuilder(LicorizeApiUrls.REMOVE_STRIP);
        String apiUrl = builder.withField("STRIP_ID", String.valueOf(stripId)).buildUrl();
        return this.readResponse(this.callOAuthApiMethod(apiUrl));
    }

    @Override
    public LicorizeApiResponse changeStripType(int stripId, String stripType) {
        this.assertPositiveNumber("strip ID", stripId);
        this.assertNotNullOrEmpty("strip type", stripType);
        LicorizeApiUrls.LicorizeApiUrlBuilder builder = this.createLicorizeApiUrlBuilder(LicorizeApiUrls.CHANGE_STRIP_TYPE);
        String apiUrl = builder.withField("STRIP_ID", String.valueOf(stripId)).buildUrl();
        ArrayList<Parameter<String, String>> _parameters = new ArrayList<Parameter<String, String>>();
        _parameters.add(new Parameter<String, String>("type", stripType));
        return this.readResponse(this.callOAuthApiMethod(apiUrl, _parameters));
    }

    @Override
    public LicorizeApiResponse getProjectsList() {
        return this.readResponse(this.callOAuthApiMethod(LicorizeApiUrls.GET_PROJECTS_LIST));
    }

    @Override
    public LicorizeApiResponse updateProject(int projectId, List<Parameter<String, String>> parameters) {
        this.assertPositiveNumber("project ID", projectId);
        ArrayList<Parameter<String, String>> _parameters = new ArrayList<Parameter<String, String>>();
        _parameters.add(new Parameter<String, Integer>("id", projectId));
        if (parameters != null) {
            _parameters.addAll(parameters);
        }
        return this.createProject(_parameters);
    }

    @Override
    public LicorizeApiResponse createProject(List<Parameter<String, String>> parameters) {
        ArrayList<Parameter<String, String>> _parameters = new ArrayList<Parameter<String, String>>();
        if (parameters != null) {
            _parameters.addAll(parameters);
        }
        return this.readResponse(this.callOAuthApiMethod(LicorizeApiUrls.UPDATE_PROJECT, _parameters));
    }

    @Override
    public LicorizeApiResponse getProject(int projectId) {
        this.assertPositiveNumber("project ID", projectId);
        LicorizeApiUrls.LicorizeApiUrlBuilder builder = this.createLicorizeApiUrlBuilder(LicorizeApiUrls.GET_PROJECT);
        String apiUrl = builder.withField("PROJECT_ID", String.valueOf(projectId)).buildUrl();
        return this.readResponse(this.callOAuthApiMethod(apiUrl));
    }

    @Override
    public LicorizeApiResponse getProjectMembers(int projectId) {
        this.assertPositiveNumber("project ID", projectId);
        LicorizeApiUrls.LicorizeApiUrlBuilder builder = this.createLicorizeApiUrlBuilder(LicorizeApiUrls.GET_PROJECT_MEMBERS);
        String apiUrl = builder.withField("PROJECT_ID", String.valueOf(projectId)).buildUrl();
        return this.readResponse(this.callOAuthApiMethod(apiUrl));
    }

    @Override
    public LicorizeApiResponse removeProject(int projectId) {
        this.assertPositiveNumber("project ID", projectId);
        LicorizeApiUrls.LicorizeApiUrlBuilder builder = this.createLicorizeApiUrlBuilder(LicorizeApiUrls.REMOVE_PROJECT);
        String apiUrl = builder.withField("PROJECT_ID", String.valueOf(projectId)).buildUrl();
        return this.readResponse(this.callOAuthApiMethod(apiUrl));
    }

    @Override
    public LicorizeApiResponse getTagsList() {
        return this.readResponse(this.callOAuthApiMethod(LicorizeApiUrls.GET_TAGS_LIST));
    }

    @Override
    public LicorizeApiResponse getUser() {
        return this.readResponse(this.callOAuthApiMethod(LicorizeApiUrls.GET_USER));
    }

    @Override
    public LicorizeApiResponse getPublicUser(String userName) {
        this.assertNotNullOrEmpty("user name", userName);
        LicorizeApiUrls.LicorizeApiUrlBuilder builder = this.createLicorizeApiUrlBuilder(LicorizeApiUrls.GET_PUBLIC_USER);
        String apiUrl = builder.withField("USER_NAME", String.valueOf(userName)).buildUrl();
        return this.readResponse(this.callApiMethod(apiUrl));
    }

    @Override
    public LicorizeApiResponse remindMeLater(String url) {
        return this.remindMeLater(url, null);
    }

    @Override
    public LicorizeApiResponse remindMeLater(String url, List<Parameter<String, String>> parameters) {
        this.assertNotNullOrEmpty("url", url);
        ArrayList<Parameter<String, String>> _parameters = new ArrayList<Parameter<String, String>>();
        _parameters.add(new Parameter<String, String>("url", url));
        if (parameters != null) {
            _parameters.addAll(parameters);
        }
        return this.readResponse(this.callOAuthApiMethod(LicorizeApiUrls.REMIND_ME_LATER, _parameters));
    }

    protected LicorizeApiUrls.LicorizeApiUrlBuilder createLicorizeApiUrlBuilder(String urlFormat) {
        return new LicorizeApiUrls.LicorizeApiUrlBuilder(urlFormat);
    }

    protected Response callOAuthApiMethod(String apiUrl) {
        List<Parameter<String, String>> parameters = Collections.emptyList();
        return this.callOAuthApiMethod(apiUrl, parameters, Verb.POST);
    }

    protected Response callOAuthApiMethod(String apiUrl, List<Parameter<String, String>> parameters) {
        return this.callOAuthApiMethod(apiUrl, parameters, Verb.POST);
    }

    protected Response callOAuthApiMethod(String apiUrl, List<Parameter<String, String>> parameters, Verb verb) {
        try {
            OAuthService service = this.buildService();
            OAuthRequest request = new OAuthRequest(verb, apiUrl);
            if (null != parameters) {
                for (Parameter<String, String> parameter : parameters) {
                    request.addBodyParameter(String.valueOf(parameter.getName()), String.valueOf(parameter.getValue()));
                }
            }
            service.signRequest(this.accessToken, request);
            request.setTimeout(LicorizeClientConstants.CONNECT_TIMEOUT);
            return request.send();
        }
        catch (Exception e) {
            throw new LicorizeClientException(e);
        }
    }

    protected Response callApiMethod(String apiUrl) {
        return this.callApiMethod(apiUrl, Verb.GET);
    }

    protected Response callApiMethod(String apiUrl, Verb verb) {
        try {
            OAuthRequest request = new OAuthRequest(verb, apiUrl);
            request.setTimeout(LicorizeClientConstants.CONNECT_TIMEOUT);
            return request.send();
        }
        catch (Exception e) {
            throw new LicorizeClientException(e);
        }
    }

    protected LicorizeApiResponse readResponse(Response response) {
        return this.unmarshallObject(response);
    }

    protected LicorizeApiResponse unmarshallObject(Response response) {
        try {
            String responseBody = response.getBody();
            JSONObject responseJson = JSONObject.fromObject((Object)responseBody);
            LicorizeApiResponseImpl apiResponse = new LicorizeApiResponseImpl();
            apiResponse.setSuccess(responseJson.getBoolean("ok"));
            apiResponse.setError(responseJson.optString("error"));
            apiResponse.setMessage(responseJson.optString("message"));
            apiResponse.setResponseString(responseBody);
            apiResponse.setResponseObject(responseJson);
            return apiResponse;
        }
        catch (Exception e) {
            throw new LicorizeClientException(e);
        }
    }

    protected OAuthService buildService() {
        OAuthService service = new ServiceBuilder().provider(LicorizeApi.class).apiKey(this.apiConsumer.getToken()).apiSecret(this.apiConsumer.getSecret()).build();
        return service;
    }

    protected boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected void assertNotNullOrEmpty(String name, String value) {
        if (this.isNullOrEmpty(value)) {
            throw new IllegalArgumentException(name + " cannot be null or empty.");
        }
    }

    protected void assertPositiveNumber(String name, int value) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be less than zero.");
        }
    }

    private static void validateRequestToken(Token requestToken) {
        if (requestToken == null) {
            throw new IllegalArgumentException("request token cannot be null.");
        }
        if (requestToken.getToken() == null || requestToken.getToken().length() == 0) {
            throw new IllegalArgumentException("request token cannot be null or empty.");
        }
    }
}

