package com.licorize.api.client;

import java.util.Date;

/**
 * @author Federico Soldani - fsoldani@open-lab.com
 */
public class LicorizeClientException extends RuntimeException {
  private int statusCode;
  private String errorCode;
  private Date timestamp;

  private static final long serialVersionUID = 5860100860704522231L;

  /**
   * Constructs ...
   */
  public LicorizeClientException() {
    super();
  }

  /**
   * Constructs ...
   *
   * @param message
   */
  public LicorizeClientException(String message) {
    super(message);
  }

  /**
   * Constructs ...
   *
   * @param cause
   */
  public LicorizeClientException(Throwable cause) {
    super(cause);
  }

  /**
   * Constructs ...
   *
   * @param message
   * @param cause
   */
  public LicorizeClientException(String message, Throwable cause) {
    super(message, cause);
  }

  /**
   * Constructs ...
   *
   * @param message
   * @param cause
   */
  public LicorizeClientException(String message, int statusCode, String errorCode, Date timestamp) {
    super(message);
    this.statusCode = statusCode;
    this.errorCode = errorCode;
    this.timestamp = timestamp;
  }

  /**
   * @return the statusCode
   */
  public int getStatusCode() {
    return statusCode;
  }

  /**
   * @param statusCode the statusCode to set
   */
  public void setStatusCode(int statusCode) {
    this.statusCode = statusCode;
  }

  /**
   * @return the errorCode
   */
  public String getErrorCode() {
    return errorCode;
  }

  /**
   * @param errorCode the errorCode to set
   */
  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  /**
   * @return the timestamp
   */
  public Date getTimestamp() {
    return timestamp;
  }

  /**
   * @param timestamp the timestamp to set
   */
  public void setTimestamp(Date timestamp) {
    this.timestamp = timestamp;
  }
}
