package com.openai.core.http

import com.openai.core.closeWhenPhantomReachable
import java.util.stream.Stream

internal class PhantomReachableClosingStreamResponse<T>(
    private val streamResponse: StreamResponse<T>
) : StreamResponse<T> {
    init {
        closeWhenPhantomReachable(this, streamResponse)
    }

    override fun stream(): Stream<T> = streamResponse.stream()

    override fun close() = streamResponse.close()
}
