/*
 * Decompiled with CFR 0.152.
 */
package com.openai.models;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.openai.core.BaseDeserializer;
import com.openai.core.BaseSerializer;
import com.openai.core.JsonField;
import com.openai.core.JsonValue;
import com.openai.core.Utils;
import com.openai.errors.OpenAIInvalidDataException;
import com.openai.models.ImageFileContentBlock;
import com.openai.models.ImageUrlContentBlock;
import com.openai.models.MessageContent;
import com.openai.models.RefusalContentBlock;
import com.openai.models.TextContentBlock;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 $2\u00020\u0001:\u0004$%&'BC\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fJ\u001f\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\u0007J\u0013\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fJ\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fJ\u0006\u0010\u001d\u001a\u00020\u000eJ\u0006\u0010\u001e\u001a\u00020\u000eJ\u0006\u0010\u001f\u001a\u00020\u000eJ\u0006\u0010 \u001a\u00020\u000eJ\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fJ\b\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/openai/models/MessageContent;", "", "imageFile", "Lcom/openai/models/ImageFileContentBlock;", "imageUrl", "Lcom/openai/models/ImageUrlContentBlock;", "text", "Lcom/openai/models/TextContentBlock;", "refusal", "Lcom/openai/models/RefusalContentBlock;", "_json", "Lcom/openai/core/JsonValue;", "(Lcom/openai/models/ImageFileContentBlock;Lcom/openai/models/ImageUrlContentBlock;Lcom/openai/models/TextContentBlock;Lcom/openai/models/RefusalContentBlock;Lcom/openai/core/JsonValue;)V", "validated", "", "Ljava/util/Optional;", "accept", "T", "visitor", "Lcom/openai/models/MessageContent$Visitor;", "(Lcom/openai/models/MessageContent$Visitor;)Ljava/lang/Object;", "asImageFile", "asImageUrl", "asRefusal", "asText", "equals", "other", "hashCode", "", "isImageFile", "isImageUrl", "isRefusal", "isText", "toString", "", "validate", "Companion", "Deserializer", "Serializer", "Visitor", "openai-java-core"})
public final class MessageContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ImageFileContentBlock imageFile;
    @Nullable
    private final ImageUrlContentBlock imageUrl;
    @Nullable
    private final TextContentBlock text;
    @Nullable
    private final RefusalContentBlock refusal;
    @Nullable
    private final JsonValue _json;
    private boolean validated;

    private MessageContent(ImageFileContentBlock imageFile, ImageUrlContentBlock imageUrl, TextContentBlock text, RefusalContentBlock refusal2, JsonValue _json) {
        this.imageFile = imageFile;
        this.imageUrl = imageUrl;
        this.text = text;
        this.refusal = refusal2;
        this._json = _json;
    }

    /* synthetic */ MessageContent(ImageFileContentBlock imageFileContentBlock, ImageUrlContentBlock imageUrlContentBlock, TextContentBlock textContentBlock, RefusalContentBlock refusalContentBlock, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            imageFileContentBlock = null;
        }
        if ((n & 2) != 0) {
            imageUrlContentBlock = null;
        }
        if ((n & 4) != 0) {
            textContentBlock = null;
        }
        if ((n & 8) != 0) {
            refusalContentBlock = null;
        }
        if ((n & 0x10) != 0) {
            jsonValue = null;
        }
        this(imageFileContentBlock, imageUrlContentBlock, textContentBlock, refusalContentBlock, jsonValue);
    }

    @NotNull
    public final Optional<ImageFileContentBlock> imageFile() {
        Optional<ImageFileContentBlock> optional = Optional.ofNullable(this.imageFile);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<ImageUrlContentBlock> imageUrl() {
        Optional<ImageUrlContentBlock> optional = Optional.ofNullable(this.imageUrl);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<TextContentBlock> text() {
        Optional<TextContentBlock> optional = Optional.ofNullable(this.text);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<RefusalContentBlock> refusal() {
        Optional<RefusalContentBlock> optional = Optional.ofNullable(this.refusal);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final boolean isImageFile() {
        return this.imageFile != null;
    }

    public final boolean isImageUrl() {
        return this.imageUrl != null;
    }

    public final boolean isText() {
        return this.text != null;
    }

    public final boolean isRefusal() {
        return this.refusal != null;
    }

    @NotNull
    public final ImageFileContentBlock asImageFile() {
        return (ImageFileContentBlock)Utils.getOrThrow(this.imageFile, "imageFile");
    }

    @NotNull
    public final ImageUrlContentBlock asImageUrl() {
        return (ImageUrlContentBlock)Utils.getOrThrow(this.imageUrl, "imageUrl");
    }

    @NotNull
    public final TextContentBlock asText() {
        return (TextContentBlock)Utils.getOrThrow(this.text, "text");
    }

    @NotNull
    public final RefusalContentBlock asRefusal() {
        return (RefusalContentBlock)Utils.getOrThrow(this.refusal, "refusal");
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        Optional<JsonValue> optional = Optional.ofNullable(this._json);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.imageFile != null ? visitor.visitImageFile(this.imageFile) : (this.imageUrl != null ? visitor.visitImageUrl(this.imageUrl) : (this.text != null ? visitor.visitText(this.text) : (this.refusal != null ? visitor.visitRefusal(this.refusal) : visitor.unknown(this._json))));
    }

    @NotNull
    public final MessageContent validate() {
        MessageContent messageContent;
        MessageContent $this$validate_u24lambda_u240 = messageContent = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                public void visitImageFile(@NotNull ImageFileContentBlock imageFile) {
                    Intrinsics.checkNotNullParameter((Object)imageFile, (String)"imageFile");
                    imageFile.validate();
                }

                public void visitImageUrl(@NotNull ImageUrlContentBlock imageUrl) {
                    Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
                    imageUrl.validate();
                }

                public void visitText(@NotNull TextContentBlock text) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    text.validate();
                }

                public void visitRefusal(@NotNull RefusalContentBlock refusal2) {
                    Intrinsics.checkNotNullParameter((Object)refusal2, (String)"refusal");
                    refusal2.validate();
                }
            });
            $this$validate_u24lambda_u240.validated = true;
        }
        return messageContent;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MessageContent && Intrinsics.areEqual((Object)this.imageFile, (Object)((MessageContent)other).imageFile) && Intrinsics.areEqual((Object)this.imageUrl, (Object)((MessageContent)other).imageUrl) && Intrinsics.areEqual((Object)this.text, (Object)((MessageContent)other).text) && Intrinsics.areEqual((Object)this.refusal, (Object)((MessageContent)other).refusal);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.imageFile, this.imageUrl, this.text, this.refusal};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.imageFile != null) {
            string = "MessageContent{imageFile=" + this.imageFile + '}';
        } else if (this.imageUrl != null) {
            string = "MessageContent{imageUrl=" + this.imageUrl + '}';
        } else if (this.text != null) {
            string = "MessageContent{text=" + this.text + '}';
        } else if (this.refusal != null) {
            string = "MessageContent{refusal=" + this.refusal + '}';
        } else if (this._json != null) {
            string = "MessageContent{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid MessageContent");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final MessageContent ofImageFile(@NotNull ImageFileContentBlock imageFile) {
        return Companion.ofImageFile(imageFile);
    }

    @JvmStatic
    @NotNull
    public static final MessageContent ofImageUrl(@NotNull ImageUrlContentBlock imageUrl) {
        return Companion.ofImageUrl(imageUrl);
    }

    @JvmStatic
    @NotNull
    public static final MessageContent ofText(@NotNull TextContentBlock text) {
        return Companion.ofText(text);
    }

    @JvmStatic
    @NotNull
    public static final MessageContent ofRefusal(@NotNull RefusalContentBlock refusal2) {
        return Companion.ofRefusal(refusal2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/openai/models/MessageContent$Companion;", "", "()V", "ofImageFile", "Lcom/openai/models/MessageContent;", "imageFile", "Lcom/openai/models/ImageFileContentBlock;", "ofImageUrl", "imageUrl", "Lcom/openai/models/ImageUrlContentBlock;", "ofRefusal", "refusal", "Lcom/openai/models/RefusalContentBlock;", "ofText", "text", "Lcom/openai/models/TextContentBlock;", "openai-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MessageContent ofImageFile(@NotNull ImageFileContentBlock imageFile) {
            Intrinsics.checkNotNullParameter((Object)imageFile, (String)"imageFile");
            return new MessageContent(imageFile, null, null, null, null, 30, null);
        }

        @JvmStatic
        @NotNull
        public final MessageContent ofImageUrl(@NotNull ImageUrlContentBlock imageUrl) {
            Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
            return new MessageContent(null, imageUrl, null, null, null, 29, null);
        }

        @JvmStatic
        @NotNull
        public final MessageContent ofText(@NotNull TextContentBlock text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new MessageContent(null, null, text, null, null, 27, null);
        }

        @JvmStatic
        @NotNull
        public final MessageContent ofRefusal(@NotNull RefusalContentBlock refusal2) {
            Intrinsics.checkNotNullParameter((Object)refusal2, (String)"refusal");
            return new MessageContent(null, null, null, refusal2, null, 23, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/openai/models/MessageContent$Deserializer;", "Lcom/openai/core/BaseDeserializer;", "Lcom/openai/models/MessageContent;", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nMessageContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageContent.kt\ncom/openai/models/MessageContent$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,232:1\n51#2:233\n51#2:234\n51#2:235\n51#2:236\n*S KotlinDebug\n*F\n+ 1 MessageContent.kt\ncom/openai/models/MessageContent$Deserializer\n*L\n185#1:233\n191#1:234\n197#1:235\n203#1:236\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<MessageContent> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(MessageContent.class));
        }

        @Override
        @NotNull
        protected MessageContent deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            JsonValue json2;
            block16: {
                String type;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                json2 = JsonValue.Companion.fromJsonNode(node);
                Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                String string = type = object != null && (object = (JsonValue)object.get("type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                if (string == null) break block16;
                int n = -1;
                switch (string.hashCode()) {
                    case -877823861: {
                        if (string.equals("image_url")) {
                            n = 1;
                        }
                        break;
                    }
                    case 1085547100: {
                        if (string.equals("refusal")) {
                            n = 2;
                        }
                        break;
                    }
                    case -1443191328: {
                        if (string.equals("image_file")) {
                            n = 3;
                        }
                        break;
                    }
                    case 3556653: {
                        if (string.equals("text")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 3: {
                        boolean $i$f$jacksonTypeRef = false;
                        ImageFileContentBlock imageFileContentBlock = (ImageFileContentBlock)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<ImageFileContentBlock>(){}, (Function1)deserialize.1.INSTANCE);
                        if (imageFileContentBlock == null) break;
                        ImageFileContentBlock it = imageFileContentBlock;
                        boolean bl = false;
                        return new MessageContent(it, null, null, null, json2, 14, null);
                    }
                    case 1: {
                        boolean $i$f$jacksonTypeRef = false;
                        ImageUrlContentBlock imageUrlContentBlock = (ImageUrlContentBlock)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<ImageUrlContentBlock>(){}, (Function1)deserialize.3.INSTANCE);
                        if (imageUrlContentBlock == null) break;
                        ImageUrlContentBlock it = imageUrlContentBlock;
                        boolean bl = false;
                        return new MessageContent(null, it, null, null, json2, 13, null);
                    }
                    case 4: {
                        boolean $i$f$jacksonTypeRef = false;
                        TextContentBlock textContentBlock = (TextContentBlock)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<TextContentBlock>(){}, (Function1)deserialize.5.INSTANCE);
                        if (textContentBlock == null) break;
                        TextContentBlock it = textContentBlock;
                        boolean bl = false;
                        return new MessageContent(null, null, it, null, json2, 11, null);
                    }
                    case 2: {
                        boolean $i$f$jacksonTypeRef = false;
                        RefusalContentBlock refusalContentBlock = (RefusalContentBlock)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<RefusalContentBlock>(){}, (Function1)deserialize.7.INSTANCE);
                        if (refusalContentBlock == null) break;
                        RefusalContentBlock it = refusalContentBlock;
                        boolean bl = false;
                        return new MessageContent(null, null, null, it, json2, 7, null);
                    }
                }
            }
            return new MessageContent(null, null, null, null, json2, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/openai/models/MessageContent$Serializer;", "Lcom/openai/core/BaseSerializer;", "Lcom/openai/models/MessageContent;", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "openai-java-core"})
    public static final class Serializer
    extends BaseSerializer<MessageContent> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(MessageContent.class));
        }

        public void serialize(@NotNull MessageContent value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (value.imageFile != null) {
                generator.writeObject((Object)value.imageFile);
            } else if (value.imageUrl != null) {
                generator.writeObject((Object)value.imageUrl);
            } else if (value.text != null) {
                generator.writeObject((Object)value.text);
            } else if (value.refusal != null) {
                generator.writeObject((Object)value.refusal);
            } else if (value._json != null) {
                generator.writeObject((Object)value._json);
            } else {
                throw new IllegalStateException("Invalid MessageContent");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H&\u00a2\u0006\u0002\u0010\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lcom/openai/models/MessageContent$Visitor;", "T", "", "unknown", "json", "Lcom/openai/core/JsonValue;", "(Lcom/openai/core/JsonValue;)Ljava/lang/Object;", "visitImageFile", "imageFile", "Lcom/openai/models/ImageFileContentBlock;", "(Lcom/openai/models/ImageFileContentBlock;)Ljava/lang/Object;", "visitImageUrl", "imageUrl", "Lcom/openai/models/ImageUrlContentBlock;", "(Lcom/openai/models/ImageUrlContentBlock;)Ljava/lang/Object;", "visitRefusal", "refusal", "Lcom/openai/models/RefusalContentBlock;", "(Lcom/openai/models/RefusalContentBlock;)Ljava/lang/Object;", "visitText", "text", "Lcom/openai/models/TextContentBlock;", "(Lcom/openai/models/TextContentBlock;)Ljava/lang/Object;", "openai-java-core"})
    public static interface Visitor<T> {
        public T visitImageFile(@NotNull ImageFileContentBlock var1);

        public T visitImageUrl(@NotNull ImageUrlContentBlock var1);

        public T visitText(@NotNull TextContentBlock var1);

        public T visitRefusal(@NotNull RefusalContentBlock var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new OpenAIInvalidDataException("Unknown MessageContent: " + json2, null, 2, null);
        }
    }
}

