/*
 * Decompiled with CFR 0.152.
 */
package com.openai.services.blocking.chat;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.openai.core.ClientOptions;
import com.openai.core.JsonValue;
import com.openai.core.PrepareRequest;
import com.openai.core.RequestOptions;
import com.openai.core.handlers.ErrorHandler;
import com.openai.core.handlers.SseHandler;
import com.openai.core.http.HttpMethod;
import com.openai.core.http.HttpRequest;
import com.openai.core.http.HttpRequestBody;
import com.openai.core.http.HttpResponse;
import com.openai.core.http.SseMessage;
import com.openai.core.http.StreamResponse;
import com.openai.core.http.StreamResponseKt;
import com.openai.errors.OpenAIError;
import com.openai.errors.OpenAIException;
import com.openai.models.ChatCompletion;
import com.openai.models.ChatCompletionChunk;
import com.openai.models.ChatCompletionCreateParams;
import com.openai.models.ChatCompletionDeleteParams;
import com.openai.models.ChatCompletionDeleted;
import com.openai.models.ChatCompletionRetrieveParams;
import com.openai.models.ChatCompletionUpdateParams;
import com.openai.services.blocking.chat.CompletionService;
import com.openai.services.blocking.chat.CompletionServiceImpl;
import com.openai.services.blocking.chat.completions.MessageService;
import com.openai.services.blocking.chat.completions.MessageServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010!\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/openai/services/blocking/chat/CompletionServiceImpl;", "Lcom/openai/services/blocking/chat/CompletionService;", "clientOptions", "Lcom/openai/core/ClientOptions;", "(Lcom/openai/core/ClientOptions;)V", "createHandler", "Lcom/openai/core/http/HttpResponse$Handler;", "Lcom/openai/models/ChatCompletion;", "createStreamingHandler", "Lcom/openai/core/http/StreamResponse;", "Lcom/openai/models/ChatCompletionChunk;", "deleteHandler", "Lcom/openai/models/ChatCompletionDeleted;", "errorHandler", "Lcom/openai/errors/OpenAIError;", "messages", "Lcom/openai/services/blocking/chat/completions/MessageService;", "getMessages", "()Lcom/openai/services/blocking/chat/completions/MessageService;", "messages$delegate", "Lkotlin/Lazy;", "retrieveHandler", "updateHandler", "create", "params", "Lcom/openai/models/ChatCompletionCreateParams;", "requestOptions", "Lcom/openai/core/RequestOptions;", "createStreaming", "delete", "Lcom/openai/models/ChatCompletionDeleteParams;", "retrieve", "Lcom/openai/models/ChatCompletionRetrieveParams;", "update", "Lcom/openai/models/ChatCompletionUpdateParams;", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nCompletionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionServiceImpl.kt\ncom/openai/services/blocking/chat/CompletionServiceImpl\n+ 2 JsonHandler.kt\ncom/openai/core/handlers/JsonHandler\n+ 3 SseHandler.kt\ncom/openai/core/handlers/SseHandler\n+ 4 HttpRequestBodies.kt\ncom/openai/core/HttpRequestBodies\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n13#2,9:210\n13#2,9:232\n13#2,9:241\n13#2,9:250\n122#3,13:219\n17#4:259\n17#4:261\n17#4:262\n1#5:260\n*S KotlinDebug\n*F\n+ 1 CompletionServiceImpl.kt\ncom/openai/services/blocking/chat/CompletionServiceImpl\n*L\n43#1:210,9\n126#1:232,9\n153#1:241,9\n182#1:250,9\n79#1:219,13\n64#1:259\n102#1:261\n168#1:262\n*E\n"})
public final class CompletionServiceImpl
implements CompletionService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<OpenAIError> errorHandler;
    @NotNull
    private final Lazy messages$delegate;
    @NotNull
    private final HttpResponse.Handler<ChatCompletion> createHandler;
    @NotNull
    private final HttpResponse.Handler<StreamResponse<ChatCompletionChunk>> createStreamingHandler;
    @NotNull
    private final HttpResponse.Handler<ChatCompletion> retrieveHandler;
    @NotNull
    private final HttpResponse.Handler<ChatCompletion> updateHandler;
    @NotNull
    private final HttpResponse.Handler<ChatCompletionDeleted> deleteHandler;

    public CompletionServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        this.messages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MessageServiceImpl>(this){
            final /* synthetic */ CompletionServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MessageServiceImpl invoke() {
                return new MessageServiceImpl(CompletionServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.createHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ChatCompletion>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ChatCompletion handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ChatCompletion>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        HttpResponse.Handler $this$mapJson_u24default$iv = SseHandler.sseHandler(this.clientOptions.jsonMapper());
        boolean includeEventAndData$iv = false;
        boolean $i$f$mapJson = false;
        this.createStreamingHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<StreamResponse<ChatCompletionChunk>>($this$mapJson_u24default$iv, includeEventAndData$iv){
            final /* synthetic */ HttpResponse.Handler $this_mapJson;
            final /* synthetic */ boolean $includeEventAndData;
            {
                this.$this_mapJson = $receiver;
                this.$includeEventAndData = $includeEventAndData;
            }

            @NotNull
            public StreamResponse<ChatCompletionChunk> handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return StreamResponseKt.map((StreamResponse)this.$this_mapJson.handle(response), (Function1)new Function1<SseMessage, ChatCompletionChunk>(this.$includeEventAndData){
                    final /* synthetic */ boolean $includeEventAndData;
                    {
                        this.$includeEventAndData = $includeEventAndData;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final ChatCompletionChunk invoke(@NotNull SseMessage it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        try {
                            void this_$iv;
                            object = it;
                            boolean includeEventAndData$iv = this.$includeEventAndData;
                            boolean $i$f$json = false;
                            JsonNode jsonNode$iv = SseMessage.access$getJsonNode((SseMessage)this_$iv);
                            if (includeEventAndData$iv) {
                                ObjectNode newJsonNode$iv = this_$iv.getJsonMapper().createObjectNode();
                                String string = this_$iv.getEvent();
                                if (string != null) {
                                    String it$iv = string;
                                    boolean bl = false;
                                    newJsonNode$iv.put("event", this_$iv.getEvent());
                                }
                                newJsonNode$iv.replace("data", jsonNode$iv);
                                jsonNode$iv = (JsonNode)newJsonNode$iv;
                            }
                            boolean $i$f$jacksonTypeRef = false;
                            object = this_$iv.getJsonMapper().readerFor((TypeReference)new TypeReference<ChatCompletionChunk>(){}).readValue(jsonNode$iv);
                        }
                        catch (Exception e) {
                            throw new OpenAIException("Error reading response", e);
                        }
                        return object;
                    }
                });
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.retrieveHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ChatCompletion>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ChatCompletion handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ChatCompletion>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.updateHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ChatCompletion>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ChatCompletion handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ChatCompletion>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.deleteHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ChatCompletionDeleted>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ChatCompletionDeleted handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ChatCompletionDeleted>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    private final MessageService getMessages() {
        Lazy lazy = this.messages$delegate;
        return (MessageService)lazy.getValue();
    }

    @Override
    @NotNull
    public MessageService messages() {
        return this.getMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ChatCompletion create(@NotNull ChatCompletionCreateParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"chat", "completions"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        ChatCompletionCreateParams.ChatCompletionCreateBody value$iv = params._body$openai_java_core();
        boolean $i$f$json22 = false;
        HttpRequest request2 = PrepareRequest.prepare(builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
            @Nullable
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new OpenAIException("Error writing request", e);
                }
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build(), this.clientOptions, params, params.model().toString());
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        Object object = response;
        Throwable $i$f$json22 = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl = false;
            it = this.createHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            $i$f$json22 = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)$i$f$json22);
        }
        Object it = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((ChatCompletion)it).validate();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public StreamResponse<ChatCompletionChunk> createStreaming(@NotNull ChatCompletionCreateParams params, @NotNull RequestOptions requestOptions) {
        HttpResponse response;
        void value$iv;
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"chat", "completions"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        ChatCompletionCreateParams.ChatCompletionCreateBody chatCompletionCreateBody = params._body$openai_java_core().toBuilder().putAdditionalProperty("stream", JsonValue.Companion.from(true)).build();
        boolean $i$f$json = false;
        HttpRequest request2 = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params, params.model().toString());
        HttpResponse it = response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        StreamResponse streamResponse = this.createStreamingHandler.handle(it);
        boolean bl2 = false;
        Boolean bl3 = requestOptions.getResponseValidation();
        return (bl3 != null ? bl3.booleanValue() : this.clientOptions.responseValidation()) ? StreamResponseKt.map(streamResponse, createStreaming.2.1.INSTANCE) : streamResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ChatCompletion retrieve(@NotNull ChatCompletionRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"chat", "completions", params.getPathParam(0)};
        HttpRequest request2 = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl = false;
            it = this.retrieveHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((ChatCompletion)it).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ChatCompletion update(@NotNull ChatCompletionUpdateParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"chat", "completions", params.getPathParam(0)};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        ChatCompletionUpdateParams.ChatCompletionUpdateBody value$iv = params._body$openai_java_core();
        boolean $i$f$json22 = false;
        HttpRequest request2 = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params, null);
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        Object object = response;
        Throwable $i$f$json22 = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl = false;
            it = this.updateHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            $i$f$json22 = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)$i$f$json22);
        }
        Object it = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((ChatCompletion)it).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ChatCompletionDeleted delete(@NotNull ChatCompletionDeleteParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Object object = new String[]{"chat", "completions", params.getPathParam(0)};
        Object $this$delete_u24lambda_u249 = object = HttpRequest.Companion.builder().method(HttpMethod.DELETE).addPathSegments((String[])object);
        boolean $i$a$-apply-CompletionServiceImpl$delete$request$22 = false;
        params._body$openai_java_core().ifPresent(arg_0 -> CompletionServiceImpl.delete$lambda$9$lambda$8((Function1)new Function1<Map<String, ? extends JsonValue>, Unit>((HttpRequest.Builder)$this$delete_u24lambda_u249, this){
            final /* synthetic */ HttpRequest.Builder $this_apply;
            final /* synthetic */ CompletionServiceImpl this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull Map<String, ? extends JsonValue> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                JsonMapper jsonMapper$iv = CompletionServiceImpl.access$getClientOptions$p(this.this$0).jsonMapper();
                boolean $i$f$json = false;
                this.$this_apply.body(new /* invalid duplicate definition of identical inner class */);
            }
        }, arg_0));
        HttpRequest request2 = PrepareRequest.prepare(((HttpRequest.Builder)object).build(), this.clientOptions, params, null);
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        Object object2 = response;
        Throwable $i$a$-apply-CompletionServiceImpl$delete$request$22 = null;
        try {
            Object it = (HttpResponse)object2;
            boolean bl = false;
            it = this.deleteHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            $i$a$-apply-CompletionServiceImpl$delete$request$22 = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)$i$a$-apply-CompletionServiceImpl$delete$request$22);
        }
        Object it = object2 = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((ChatCompletionDeleted)it).validate();
        }
        return object2;
    }

    private static final void delete$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(CompletionServiceImpl $this) {
        return $this.clientOptions;
    }
}

