/*
 * Decompiled with CFR 0.152.
 */
package com.openai.services.blocking.chat;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.openai.core.ClientOptions;
import com.openai.core.JsonValue;
import com.openai.core.PrepareRequest;
import com.openai.core.RequestOptions;
import com.openai.core.handlers.ErrorHandler;
import com.openai.core.handlers.SseHandler;
import com.openai.core.http.HttpMethod;
import com.openai.core.http.HttpRequest;
import com.openai.core.http.HttpRequestBody;
import com.openai.core.http.HttpResponse;
import com.openai.core.http.SseMessage;
import com.openai.core.http.StreamResponse;
import com.openai.core.http.StreamResponseKt;
import com.openai.errors.OpenAIError;
import com.openai.errors.OpenAIException;
import com.openai.models.ChatCompletion;
import com.openai.models.ChatCompletionChunk;
import com.openai.models.ChatCompletionCreateParams;
import com.openai.models.ChatCompletionDeleteParams;
import com.openai.models.ChatCompletionDeleted;
import com.openai.models.ChatCompletionRetrieveParams;
import com.openai.models.ChatCompletionUpdateParams;
import com.openai.services.blocking.chat.CompletionService;
import com.openai.services.blocking.chat.completions.MessageService;
import com.openai.services.blocking.chat.completions.MessageServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\"\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/openai/services/blocking/chat/CompletionServiceImpl;", "Lcom/openai/services/blocking/chat/CompletionService;", "clientOptions", "Lcom/openai/core/ClientOptions;", "<init>", "(Lcom/openai/core/ClientOptions;)V", "errorHandler", "Lcom/openai/core/http/HttpResponse$Handler;", "Lcom/openai/errors/OpenAIError;", "messages", "Lcom/openai/services/blocking/chat/completions/MessageService;", "getMessages", "()Lcom/openai/services/blocking/chat/completions/MessageService;", "messages$delegate", "Lkotlin/Lazy;", "createHandler", "Lcom/openai/models/ChatCompletion;", "create", "params", "Lcom/openai/models/ChatCompletionCreateParams;", "requestOptions", "Lcom/openai/core/RequestOptions;", "createStreamingHandler", "Lcom/openai/core/http/StreamResponse;", "Lcom/openai/models/ChatCompletionChunk;", "createStreaming", "retrieveHandler", "retrieve", "Lcom/openai/models/ChatCompletionRetrieveParams;", "updateHandler", "update", "Lcom/openai/models/ChatCompletionUpdateParams;", "deleteHandler", "Lcom/openai/models/ChatCompletionDeleted;", "delete", "Lcom/openai/models/ChatCompletionDeleteParams;", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nCompletionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionServiceImpl.kt\ncom/openai/services/blocking/chat/CompletionServiceImpl\n+ 2 JsonHandler.kt\ncom/openai/core/handlers/JsonHandler\n+ 3 SseHandler.kt\ncom/openai/core/handlers/SseHandler\n+ 4 HttpRequestBodies.kt\ncom/openai/core/HttpRequestBodies\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n13#2,9:208\n13#2,9:231\n13#2,9:240\n13#2,9:249\n121#3,14:217\n14#4:258\n14#4:260\n14#4:261\n14#4:262\n1#5:259\n*S KotlinDebug\n*F\n+ 1 CompletionServiceImpl.kt\ncom/openai/services/blocking/chat/CompletionServiceImpl\n*L\n41#1:208,9\n124#1:231,9\n151#1:240,9\n180#1:249,9\n77#1:217,14\n62#1:258\n100#1:260\n166#1:261\n194#1:262\n*E\n"})
public final class CompletionServiceImpl
implements CompletionService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<OpenAIError> errorHandler;
    @NotNull
    private final Lazy messages$delegate;
    @NotNull
    private final HttpResponse.Handler<ChatCompletion> createHandler;
    @NotNull
    private final HttpResponse.Handler<StreamResponse<ChatCompletionChunk>> createStreamingHandler;
    @NotNull
    private final HttpResponse.Handler<ChatCompletion> retrieveHandler;
    @NotNull
    private final HttpResponse.Handler<ChatCompletion> updateHandler;
    @NotNull
    private final HttpResponse.Handler<ChatCompletionDeleted> deleteHandler;

    public CompletionServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        this.messages$delegate = LazyKt.lazy(() -> CompletionServiceImpl.messages_delegate$lambda$0(this));
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.createHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ChatCompletion>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ChatCompletion handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ChatCompletion>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        HttpResponse.Handler $this$mapJson_u24default$iv = SseHandler.sseHandler(this.clientOptions.jsonMapper());
        boolean includeEventAndData$iv = false;
        boolean $i$f$mapJson = false;
        this.createStreamingHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<StreamResponse<ChatCompletionChunk>>($this$mapJson_u24default$iv, includeEventAndData$iv){
            final /* synthetic */ HttpResponse.Handler $this_mapJson;
            final /* synthetic */ boolean $includeEventAndData;
            {
                this.$this_mapJson = $receiver;
                this.$includeEventAndData = $includeEventAndData;
            }

            public StreamResponse<ChatCompletionChunk> handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return StreamResponseKt.map((StreamResponse)this.$this_mapJson.handle(response), (Function1)new Function1<SseMessage, ChatCompletionChunk>(this.$includeEventAndData){
                    final /* synthetic */ boolean $includeEventAndData;
                    {
                        this.$includeEventAndData = $includeEventAndData;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final ChatCompletionChunk invoke(SseMessage it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        try {
                            void this_$iv;
                            object = it;
                            boolean includeEventAndData$iv = this.$includeEventAndData;
                            boolean $i$f$json = false;
                            JsonNode jsonNode$iv = SseMessage.access$getJsonNode((SseMessage)this_$iv);
                            if (includeEventAndData$iv) {
                                ObjectNode newJsonNode$iv = this_$iv.getJsonMapper().createObjectNode();
                                String string = this_$iv.getEvent();
                                if (string != null) {
                                    String it$iv = string;
                                    boolean bl = false;
                                    newJsonNode$iv.put("event", this_$iv.getEvent());
                                }
                                newJsonNode$iv.replace("data", jsonNode$iv);
                                jsonNode$iv = (JsonNode)newJsonNode$iv;
                            }
                            boolean $i$f$jacksonTypeRef = false;
                            object = this_$iv.getJsonMapper().readerFor((TypeReference)new TypeReference<ChatCompletionChunk>(){}).readValue(jsonNode$iv);
                        }
                        catch (Exception e) {
                            throw new OpenAIException("Error reading response", e);
                        }
                        return object;
                    }
                });
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.retrieveHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ChatCompletion>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ChatCompletion handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ChatCompletion>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.updateHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ChatCompletion>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ChatCompletion handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ChatCompletion>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.deleteHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ChatCompletionDeleted>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ChatCompletionDeleted handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ChatCompletionDeleted>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    private final MessageService getMessages() {
        Lazy lazy = this.messages$delegate;
        return (MessageService)lazy.getValue();
    }

    @Override
    @NotNull
    public MessageService messages() {
        return this.getMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ChatCompletion create(@NotNull ChatCompletionCreateParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"chat", "completions"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        ChatCompletionCreateParams.Body value$iv = params._body$openai_java_core();
        boolean $i$f$json22 = false;
        HttpRequest request = PrepareRequest.prepare(builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new OpenAIException("Error writing request", e);
                }
            }

            public void writeTo(OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build(), this.clientOptions, params, params.model().toString());
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object = response;
        Throwable $i$f$json22 = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            it = this.createHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable) {
            $i$f$json22 = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)$i$f$json22);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((ChatCompletion)it2).validate();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public StreamResponse<ChatCompletionChunk> createStreaming(@NotNull ChatCompletionCreateParams params, @NotNull RequestOptions requestOptions) {
        HttpResponse response;
        void value$iv;
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"chat", "completions"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        ChatCompletionCreateParams.Body body = params._body$openai_java_core().toBuilder().putAdditionalProperty("stream", JsonValue.Companion.from(true)).build();
        boolean $i$f$json = false;
        HttpRequest request = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params, params.model().toString());
        HttpResponse it = response = this.clientOptions.httpClient().execute(request, requestOptions);
        boolean bl = false;
        StreamResponse streamResponse = this.createStreamingHandler.handle(it);
        boolean bl2 = false;
        Boolean bl3 = requestOptions.getResponseValidation();
        return (bl3 != null ? bl3.booleanValue() : this.clientOptions.responseValidation()) ? StreamResponseKt.map(streamResponse, CompletionServiceImpl::createStreaming$lambda$5$lambda$4) : streamResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ChatCompletion retrieve(@NotNull ChatCompletionRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"chat", "completions", params.getPathParam(0)};
        HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object = response;
        Throwable throwable = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            it = this.retrieveHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((ChatCompletion)it2).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ChatCompletion update(@NotNull ChatCompletionUpdateParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"chat", "completions", params.getPathParam(0)};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        ChatCompletionUpdateParams.Body value$iv = params._body$openai_java_core();
        boolean $i$f$json22 = false;
        HttpRequest request = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params, null);
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object = response;
        Throwable $i$f$json22 = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            it = this.updateHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable) {
            $i$f$json22 = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)$i$f$json22);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((ChatCompletion)it2).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ChatCompletionDeleted delete(@NotNull ChatCompletionDeleteParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Object object = new String[]{"chat", "completions", params.getPathParam(0)};
        Object $this$delete_u24lambda_u2412 = object = HttpRequest.Companion.builder().method(HttpMethod.DELETE).addPathSegments((String[])object);
        boolean $i$a$-apply-CompletionServiceImpl$delete$request$22 = false;
        params._body$openai_java_core().ifPresent(arg_0 -> CompletionServiceImpl.delete$lambda$12$lambda$11(arg_0 -> CompletionServiceImpl.delete$lambda$12$lambda$10((HttpRequest.Builder)$this$delete_u24lambda_u2412, this, arg_0), arg_0));
        HttpRequest request = PrepareRequest.prepare(((HttpRequest.Builder)object).build(), this.clientOptions, params, null);
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object2 = response;
        Throwable $i$a$-apply-CompletionServiceImpl$delete$request$22 = null;
        try {
            it = (HttpResponse)object2;
            boolean bl = false;
            it = this.deleteHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable) {
            $i$a$-apply-CompletionServiceImpl$delete$request$22 = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)$i$a$-apply-CompletionServiceImpl$delete$request$22);
        }
        Object it2 = object2 = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((ChatCompletionDeleted)it2).validate();
        }
        return object2;
    }

    private static final MessageServiceImpl messages_delegate$lambda$0(CompletionServiceImpl this$0) {
        return new MessageServiceImpl(this$0.clientOptions);
    }

    private static final ChatCompletionChunk createStreaming$lambda$5$lambda$4(ChatCompletionChunk it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.validate();
    }

    private static final Unit delete$lambda$12$lambda$10(HttpRequest.Builder $this_apply, CompletionServiceImpl this$0, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JsonMapper jsonMapper$iv = this$0.clientOptions.jsonMapper();
        boolean $i$f$json = false;
        $this_apply.body(new /* invalid duplicate definition of identical inner class */);
        return Unit.INSTANCE;
    }

    private static final void delete$lambda$12$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

