/*
 * Decompiled with CFR 0.152.
 */
package com.openai.models.responses;

import com.openai.core.JsonValue;
import com.openai.errors.OpenAIInvalidDataException;
import com.openai.models.responses.ResponseComputerToolCall;
import com.openai.models.responses.ResponseFileSearchToolCall;
import com.openai.models.responses.ResponseFunctionToolCall;
import com.openai.models.responses.ResponseFunctionWebSearch;
import com.openai.models.responses.ResponseOutputItem;
import com.openai.models.responses.ResponseOutputMessage;
import com.openai.models.responses.ResponseReasoningItem;
import com.openai.models.responses.StructuredResponseOutputItem;
import com.openai.models.responses.StructuredResponseOutputMessage;
import java.util.Objects;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u00019B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\tJ%\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0001\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0\tJ\u0013\u0010'\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\tJ\f\u0010*\u001a\b\u0012\u0004\u0012\u00020 0\tJ\b\u0010+\u001a\u00020,H\u0016J\u0006\u0010-\u001a\u00020\u0013J\u0006\u0010.\u001a\u00020\u0013J\u0006\u0010/\u001a\u00020\u0013J\u0006\u00100\u001a\u00020\u0013J\u0006\u00101\u001a\u00020\u0013J\u0006\u00102\u001a\u00020\u0013J\u0006\u00103\u001a\u00020\u0013J\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\tJ\f\u00104\u001a\b\u0012\u0004\u0012\u00020#0\tJ\b\u00105\u001a\u000206H\u0016J\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\f\u00108\u001a\b\u0012\u0004\u0012\u00020%0\tRW\u0010\b\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u000b*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n0\n \u000b*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u000b*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n0\n\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0010R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/openai/models/responses/StructuredResponseOutputItem;", "T", "", "responseType", "Ljava/lang/Class;", "rawOutputItem", "Lcom/openai/models/responses/ResponseOutputItem;", "(Ljava/lang/Class;Lcom/openai/models/responses/ResponseOutputItem;)V", "message", "Ljava/util/Optional;", "Lcom/openai/models/responses/StructuredResponseOutputMessage;", "kotlin.jvm.PlatformType", "getMessage", "()Ljava/util/Optional;", "message$delegate", "Lkotlin/Lazy;", "()Lcom/openai/models/responses/ResponseOutputItem;", "()Ljava/lang/Class;", "validated", "", "_json", "Lcom/openai/core/JsonValue;", "accept", "R", "visitor", "Lcom/openai/models/responses/StructuredResponseOutputItem$Visitor;", "(Lcom/openai/models/responses/StructuredResponseOutputItem$Visitor;)Ljava/lang/Object;", "asComputerCall", "Lcom/openai/models/responses/ResponseComputerToolCall;", "asFileSearchCall", "Lcom/openai/models/responses/ResponseFileSearchToolCall;", "asFunctionCall", "Lcom/openai/models/responses/ResponseFunctionToolCall;", "asMessage", "asReasoning", "Lcom/openai/models/responses/ResponseReasoningItem;", "asWebSearchCall", "Lcom/openai/models/responses/ResponseFunctionWebSearch;", "computerCall", "equals", "other", "fileSearchCall", "functionCall", "hashCode", "", "isComputerCall", "isFileSearchCall", "isFunctionCall", "isMessage", "isReasoning", "isValid", "isWebSearchCall", "reasoning", "toString", "", "validate", "webSearchCall", "Visitor", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nStructuredResponseOutputItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructuredResponseOutputItem.kt\ncom/openai/models/responses/StructuredResponseOutputItem\n+ 2 Optionals.kt\nkotlin/jvm/optionals/OptionalsKt\n*L\n1#1,190:1\n30#2:191\n*S KotlinDebug\n*F\n+ 1 StructuredResponseOutputItem.kt\ncom/openai/models/responses/StructuredResponseOutputItem\n*L\n64#1:191\n*E\n"})
public final class StructuredResponseOutputItem<T> {
    @NotNull
    private final Class<T> responseType;
    @NotNull
    private final ResponseOutputItem rawOutputItem;
    @NotNull
    private final Lazy message$delegate;
    private boolean validated;

    public StructuredResponseOutputItem(@NotNull Class<T> responseType, @NotNull ResponseOutputItem rawOutputItem) {
        Intrinsics.checkNotNullParameter(responseType, (String)"responseType");
        Intrinsics.checkNotNullParameter((Object)rawOutputItem, (String)"rawOutputItem");
        this.responseType = responseType;
        this.rawOutputItem = rawOutputItem;
        this.message$delegate = LazyKt.lazy((Function0)new Function0<Optional<StructuredResponseOutputMessage<T>>>(this){
            final /* synthetic */ StructuredResponseOutputItem<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Optional<StructuredResponseOutputMessage<T>> invoke() {
                return this.this$0.rawOutputItem().message().map(arg_0 -> message.2.invoke$lambda$0((Function1)new Function1<ResponseOutputMessage, StructuredResponseOutputMessage<T>>(this.this$0){
                    final /* synthetic */ StructuredResponseOutputItem<T> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final StructuredResponseOutputMessage<T> invoke(ResponseOutputMessage it) {
                        Class<T> clazz = this.this$0.responseType();
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        return new StructuredResponseOutputMessage<T>(clazz, it);
                    }
                }, arg_0));
            }

            private static final StructuredResponseOutputMessage invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (StructuredResponseOutputMessage)$tmp0.invoke(p0);
            }
        });
    }

    @JvmName(name="responseType")
    @NotNull
    public final Class<T> responseType() {
        return this.responseType;
    }

    @JvmName(name="rawOutputItem")
    @NotNull
    public final ResponseOutputItem rawOutputItem() {
        return this.rawOutputItem;
    }

    private final Optional<StructuredResponseOutputMessage<T>> getMessage() {
        Lazy lazy = this.message$delegate;
        return (Optional)lazy.getValue();
    }

    @NotNull
    public final Optional<StructuredResponseOutputMessage<T>> message() {
        Optional<StructuredResponseOutputMessage<T>> optional = this.getMessage();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"message");
        return optional;
    }

    @NotNull
    public final Optional<ResponseFileSearchToolCall> fileSearchCall() {
        return this.rawOutputItem.fileSearchCall();
    }

    @NotNull
    public final Optional<ResponseFunctionToolCall> functionCall() {
        return this.rawOutputItem.functionCall();
    }

    @NotNull
    public final Optional<ResponseFunctionWebSearch> webSearchCall() {
        return this.rawOutputItem.webSearchCall();
    }

    @NotNull
    public final Optional<ResponseComputerToolCall> computerCall() {
        return this.rawOutputItem.computerCall();
    }

    @NotNull
    public final Optional<ResponseReasoningItem> reasoning() {
        return this.rawOutputItem.reasoning();
    }

    public final boolean isMessage() {
        return this.message().isPresent();
    }

    public final boolean isFileSearchCall() {
        return this.rawOutputItem.isFileSearchCall();
    }

    public final boolean isFunctionCall() {
        return this.rawOutputItem.isFunctionCall();
    }

    public final boolean isWebSearchCall() {
        return this.rawOutputItem.isWebSearchCall();
    }

    public final boolean isComputerCall() {
        return this.rawOutputItem.isComputerCall();
    }

    public final boolean isReasoning() {
        return this.rawOutputItem.isReasoning();
    }

    @NotNull
    public final StructuredResponseOutputMessage<T> asMessage() {
        Optional<StructuredResponseOutputMessage<T>> optional = this.getMessage();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"message");
        Optional<StructuredResponseOutputMessage<T>> $this$getOrElse$iv = optional;
        boolean $i$f$getOrElse = false;
        if (!$this$getOrElse$iv.isPresent()) {
            boolean bl = false;
            throw new OpenAIInvalidDataException("`message` is not present", null, 2, null);
        }
        StructuredResponseOutputMessage<T> structuredResponseOutputMessage = $this$getOrElse$iv.get();
        Intrinsics.checkNotNullExpressionValue(structuredResponseOutputMessage, (String)"message.getOrElse {\n    \u2026s not present\")\n        }");
        return structuredResponseOutputMessage;
    }

    @NotNull
    public final ResponseFileSearchToolCall asFileSearchCall() {
        return this.rawOutputItem.asFileSearchCall();
    }

    @NotNull
    public final ResponseFunctionToolCall asFunctionCall() {
        return this.rawOutputItem.asFunctionCall();
    }

    @NotNull
    public final ResponseFunctionWebSearch asWebSearchCall() {
        return this.rawOutputItem.asWebSearchCall();
    }

    @NotNull
    public final ResponseComputerToolCall asComputerCall() {
        return this.rawOutputItem.asComputerCall();
    }

    @NotNull
    public final ResponseReasoningItem asReasoning() {
        return this.rawOutputItem.asReasoning();
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        return this.rawOutputItem._json();
    }

    public final <R> R accept(@NotNull Visitor<T, ? extends R> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.isMessage() ? visitor.visitMessage(this.asMessage()) : (this.isFileSearchCall() ? visitor.visitFileSearchCall(this.asFileSearchCall()) : (this.isFunctionCall() ? visitor.visitFunctionCall(this.asFunctionCall()) : (this.isWebSearchCall() ? visitor.visitWebSearchCall(this.asWebSearchCall()) : (this.isComputerCall() ? visitor.visitComputerCall(this.asComputerCall()) : (this.isReasoning() ? visitor.visitReasoning(this.asReasoning()) : visitor.unknown((JsonValue)OptionalsKt.getOrNull(this._json())))))));
    }

    @NotNull
    public final StructuredResponseOutputItem<T> validate() {
        StructuredResponseOutputItem structuredResponseOutputItem;
        StructuredResponseOutputItem $this$validate_u24lambda_u241 = structuredResponseOutputItem = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u241.validated) {
            $this$validate_u24lambda_u241.accept(new Visitor<T, Unit>(){

                public void visitMessage(@NotNull StructuredResponseOutputMessage<T> message2) {
                    Intrinsics.checkNotNullParameter(message2, (String)"message");
                    message2.validate();
                }

                public void visitFileSearchCall(@NotNull ResponseFileSearchToolCall fileSearchCall) {
                    Intrinsics.checkNotNullParameter((Object)fileSearchCall, (String)"fileSearchCall");
                    fileSearchCall.validate();
                }

                public void visitFunctionCall(@NotNull ResponseFunctionToolCall functionCall) {
                    Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                    functionCall.validate();
                }

                public void visitWebSearchCall(@NotNull ResponseFunctionWebSearch webSearchCall) {
                    Intrinsics.checkNotNullParameter((Object)webSearchCall, (String)"webSearchCall");
                    webSearchCall.validate();
                }

                public void visitComputerCall(@NotNull ResponseComputerToolCall computerCall) {
                    Intrinsics.checkNotNullParameter((Object)computerCall, (String)"computerCall");
                    computerCall.validate();
                }

                public void visitReasoning(@NotNull ResponseReasoningItem reasoning) {
                    Intrinsics.checkNotNullParameter((Object)reasoning, (String)"reasoning");
                    reasoning.validate();
                }
            });
            $this$validate_u24lambda_u241.validated = true;
        }
        return structuredResponseOutputItem;
    }

    public final boolean isValid() {
        boolean bl;
        try {
            this.validate();
            bl = true;
        }
        catch (OpenAIInvalidDataException _) {
            bl = false;
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StructuredResponseOutputItem && Intrinsics.areEqual(this.responseType, ((StructuredResponseOutputItem)other).responseType) && Intrinsics.areEqual((Object)this.rawOutputItem, (Object)((StructuredResponseOutputItem)other).rawOutputItem);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.responseType, this.rawOutputItem};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{responseType=" + this.responseType + ", rawOutputItem=" + this.rawOutputItem + '}';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u0002*\u0006\b\u0002\u0010\u0003 \u00012\u00020\u0002J\u0017\u0010\u0004\u001a\u00028\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00028\u00022\u0006\u0010\t\u001a\u00020\nH&\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00028\u00022\u0006\u0010\r\u001a\u00020\u000eH&\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00028\u00022\u0006\u0010\u0011\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\u00028\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0016H&\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00028\u00022\u0006\u0010\u0019\u001a\u00020\u001aH&\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00028\u00022\u0006\u0010\u001d\u001a\u00020\u001eH&\u00a2\u0006\u0002\u0010\u001f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006 \u00c0\u0006\u0001"}, d2={"Lcom/openai/models/responses/StructuredResponseOutputItem$Visitor;", "R", "", "T", "unknown", "json", "Lcom/openai/core/JsonValue;", "(Lcom/openai/core/JsonValue;)Ljava/lang/Object;", "visitComputerCall", "computerCall", "Lcom/openai/models/responses/ResponseComputerToolCall;", "(Lcom/openai/models/responses/ResponseComputerToolCall;)Ljava/lang/Object;", "visitFileSearchCall", "fileSearchCall", "Lcom/openai/models/responses/ResponseFileSearchToolCall;", "(Lcom/openai/models/responses/ResponseFileSearchToolCall;)Ljava/lang/Object;", "visitFunctionCall", "functionCall", "Lcom/openai/models/responses/ResponseFunctionToolCall;", "(Lcom/openai/models/responses/ResponseFunctionToolCall;)Ljava/lang/Object;", "visitMessage", "message", "Lcom/openai/models/responses/StructuredResponseOutputMessage;", "(Lcom/openai/models/responses/StructuredResponseOutputMessage;)Ljava/lang/Object;", "visitReasoning", "reasoning", "Lcom/openai/models/responses/ResponseReasoningItem;", "(Lcom/openai/models/responses/ResponseReasoningItem;)Ljava/lang/Object;", "visitWebSearchCall", "webSearchCall", "Lcom/openai/models/responses/ResponseFunctionWebSearch;", "(Lcom/openai/models/responses/ResponseFunctionWebSearch;)Ljava/lang/Object;", "openai-java-core"})
    public static interface Visitor<R, T> {
        public T visitMessage(@NotNull StructuredResponseOutputMessage<R> var1);

        public T visitFileSearchCall(@NotNull ResponseFileSearchToolCall var1);

        public T visitFunctionCall(@NotNull ResponseFunctionToolCall var1);

        public T visitWebSearchCall(@NotNull ResponseFunctionWebSearch var1);

        public T visitComputerCall(@NotNull ResponseComputerToolCall var1);

        public T visitReasoning(@NotNull ResponseReasoningItem var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new OpenAIInvalidDataException("Unknown ResponseOutputItem: " + json2, null, 2, null);
        }
    }
}

