/*
 * Decompiled with CFR 0.152.
 */
package com.openai.models.webhooks;

import com.openai.core.Check;
import com.openai.core.http.Headers;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\rR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000eR\u0013\u0010\t\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/openai/models/webhooks/WebhookVerificationParams;", "", "payload", "", "headers", "Lcom/openai/core/http/Headers;", "secret", "Ljava/util/Optional;", "", "tolerance", "Ljava/time/Duration;", "([BLcom/openai/core/http/Headers;Ljava/util/Optional;Ljava/time/Duration;)V", "()Lcom/openai/core/http/Headers;", "()[B", "()Ljava/util/Optional;", "()Ljava/time/Duration;", "equals", "", "other", "hashCode", "", "Builder", "Companion", "openai-java-core"})
public final class WebhookVerificationParams {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] payload;
    @NotNull
    private final Headers headers;
    @NotNull
    private final Optional<String> secret;
    @NotNull
    private final Duration tolerance;

    private WebhookVerificationParams(byte[] payload, Headers headers, Optional<String> secret, Duration tolerance) {
        this.payload = payload;
        this.headers = headers;
        this.secret = secret;
        this.tolerance = tolerance;
    }

    @JvmName(name="payload")
    @NotNull
    public final byte[] payload() {
        return this.payload;
    }

    @JvmName(name="headers")
    @NotNull
    public final Headers headers() {
        return this.headers;
    }

    @JvmName(name="secret")
    @NotNull
    public final Optional<String> secret() {
        return this.secret;
    }

    @JvmName(name="tolerance")
    @NotNull
    public final Duration tolerance() {
        return this.tolerance;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WebhookVerificationParams && Arrays.equals(this.payload, ((WebhookVerificationParams)other).payload) && Intrinsics.areEqual((Object)this.headers, (Object)((WebhookVerificationParams)other).headers) && Intrinsics.areEqual(this.secret, ((WebhookVerificationParams)other).secret) && Intrinsics.areEqual((Object)this.tolerance, (Object)((WebhookVerificationParams)other).tolerance);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{Arrays.hashCode(this.payload), this.headers, this.secret, this.tolerance};
        return Objects.hash(objectArray);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ WebhookVerificationParams(byte[] payload, Headers headers, Optional secret, Duration tolerance, DefaultConstructorMarker $constructor_marker) {
        this(payload, headers, secret, tolerance);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\tJ\u0014\u0010\u0007\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/openai/models/webhooks/WebhookVerificationParams$Builder;", "", "()V", "headers", "Lcom/openai/core/http/Headers;", "payload", "", "secret", "Ljava/util/Optional;", "", "tolerance", "Ljava/time/Duration;", "build", "Lcom/openai/models/webhooks/WebhookVerificationParams;", "toleranceSeconds", "", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nWebhookVerificationParams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebhookVerificationParams.kt\ncom/openai/models/webhooks/WebhookVerificationParams$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
    public static final class Builder {
        @Nullable
        private byte[] payload;
        @Nullable
        private Headers headers;
        @NotNull
        private Optional<String> secret;
        @NotNull
        private Duration tolerance;

        public Builder() {
            Optional optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
            this.secret = optional;
            Duration duration = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(5)");
            this.tolerance = duration;
        }

        @NotNull
        public final Builder payload(@NotNull String payload) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Builder $this$payload_u24lambda_u240 = builder = this;
            boolean bl = false;
            String string = payload;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            $this$payload_u24lambda_u240.payload = byArray;
            return builder;
        }

        @NotNull
        public final Builder payload(@NotNull byte[] payload) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Builder $this$payload_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$payload_u24lambda_u241.payload = payload;
            return builder;
        }

        @NotNull
        public final Builder headers(@NotNull Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder $this$headers_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u242.headers = headers;
            return builder;
        }

        @NotNull
        public final Builder secret(@NotNull String secret) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            Builder $this$secret_u24lambda_u243 = builder = this;
            boolean bl = false;
            Optional<String> optional = Optional.of(secret);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(secret)");
            $this$secret_u24lambda_u243.secret = optional;
            return builder;
        }

        @NotNull
        public final Builder secret(@NotNull Optional<String> secret) {
            Builder builder;
            Intrinsics.checkNotNullParameter(secret, (String)"secret");
            Builder $this$secret_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$secret_u24lambda_u244.secret = secret;
            return builder;
        }

        @NotNull
        public final Builder tolerance(@NotNull Duration tolerance) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tolerance, (String)"tolerance");
            Builder $this$tolerance_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$tolerance_u24lambda_u245.tolerance = tolerance;
            return builder;
        }

        @NotNull
        public final Builder tolerance(int toleranceSeconds) {
            Builder builder;
            Builder $this$tolerance_u24lambda_u246 = builder = this;
            boolean bl = false;
            Duration duration = Duration.ofSeconds(toleranceSeconds);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(toleranceSeconds.toLong())");
            $this$tolerance_u24lambda_u246.tolerance = duration;
            return builder;
        }

        @NotNull
        public final WebhookVerificationParams build() {
            return new WebhookVerificationParams(Check.checkRequired("payload", this.payload), Check.checkRequired("headers", this.headers), this.secret, this.tolerance, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/openai/models/webhooks/WebhookVerificationParams$Companion;", "", "()V", "builder", "Lcom/openai/models/webhooks/WebhookVerificationParams$Builder;", "openai-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

