// File generated from our OpenAPI spec by Stainless.

package com.openai.models.responses

import com.fasterxml.jackson.annotation.JsonAnyGetter
import com.fasterxml.jackson.annotation.JsonAnySetter
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty
import com.fasterxml.jackson.core.JsonGenerator
import com.fasterxml.jackson.core.ObjectCodec
import com.fasterxml.jackson.databind.JsonNode
import com.fasterxml.jackson.databind.SerializerProvider
import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import com.fasterxml.jackson.module.kotlin.jacksonTypeRef
import com.openai.core.BaseDeserializer
import com.openai.core.BaseSerializer
import com.openai.core.Enum
import com.openai.core.ExcludeMissing
import com.openai.core.JsonField
import com.openai.core.JsonMissing
import com.openai.core.JsonValue
import com.openai.core.checkKnown
import com.openai.core.checkRequired
import com.openai.core.getOrThrow
import com.openai.core.toImmutable
import com.openai.errors.OpenAIInvalidDataException
import java.util.Collections
import java.util.Objects
import java.util.Optional
import kotlin.jvm.optionals.getOrNull

/** A tool call to run code. */
class ResponseCodeInterpreterToolCall
private constructor(
    private val id: JsonField<String>,
    private val code: JsonField<String>,
    private val containerId: JsonField<String>,
    private val outputs: JsonField<List<Output>>,
    private val status: JsonField<Status>,
    private val type: JsonValue,
    private val additionalProperties: MutableMap<String, JsonValue>,
) {

    @JsonCreator
    private constructor(
        @JsonProperty("id") @ExcludeMissing id: JsonField<String> = JsonMissing.of(),
        @JsonProperty("code") @ExcludeMissing code: JsonField<String> = JsonMissing.of(),
        @JsonProperty("container_id")
        @ExcludeMissing
        containerId: JsonField<String> = JsonMissing.of(),
        @JsonProperty("outputs")
        @ExcludeMissing
        outputs: JsonField<List<Output>> = JsonMissing.of(),
        @JsonProperty("status") @ExcludeMissing status: JsonField<Status> = JsonMissing.of(),
        @JsonProperty("type") @ExcludeMissing type: JsonValue = JsonMissing.of(),
    ) : this(id, code, containerId, outputs, status, type, mutableMapOf())

    /**
     * The unique ID of the code interpreter tool call.
     *
     * @throws OpenAIInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun id(): String = id.getRequired("id")

    /**
     * The code to run, or null if not available.
     *
     * @throws OpenAIInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun code(): Optional<String> = code.getOptional("code")

    /**
     * The ID of the container used to run the code.
     *
     * @throws OpenAIInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun containerId(): String = containerId.getRequired("container_id")

    /**
     * The outputs generated by the code interpreter, such as logs or images. Can be null if no
     * outputs are available.
     *
     * @throws OpenAIInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun outputs(): Optional<List<Output>> = outputs.getOptional("outputs")

    /**
     * The status of the code interpreter tool call. Valid values are `in_progress`, `completed`,
     * `incomplete`, `interpreting`, and `failed`.
     *
     * @throws OpenAIInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun status(): Status = status.getRequired("status")

    /**
     * The type of the code interpreter tool call. Always `code_interpreter_call`.
     *
     * Expected to always return the following:
     * ```java
     * JsonValue.from("code_interpreter_call")
     * ```
     *
     * However, this method can be useful for debugging and logging (e.g. if the server responded
     * with an unexpected value).
     */
    @JsonProperty("type") @ExcludeMissing fun _type(): JsonValue = type

    /**
     * Returns the raw JSON value of [id].
     *
     * Unlike [id], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("id") @ExcludeMissing fun _id(): JsonField<String> = id

    /**
     * Returns the raw JSON value of [code].
     *
     * Unlike [code], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("code") @ExcludeMissing fun _code(): JsonField<String> = code

    /**
     * Returns the raw JSON value of [containerId].
     *
     * Unlike [containerId], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("container_id")
    @ExcludeMissing
    fun _containerId(): JsonField<String> = containerId

    /**
     * Returns the raw JSON value of [outputs].
     *
     * Unlike [outputs], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("outputs") @ExcludeMissing fun _outputs(): JsonField<List<Output>> = outputs

    /**
     * Returns the raw JSON value of [status].
     *
     * Unlike [status], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("status") @ExcludeMissing fun _status(): JsonField<Status> = status

    @JsonAnySetter
    private fun putAdditionalProperty(key: String, value: JsonValue) {
        additionalProperties.put(key, value)
    }

    @JsonAnyGetter
    @ExcludeMissing
    fun _additionalProperties(): Map<String, JsonValue> =
        Collections.unmodifiableMap(additionalProperties)

    fun toBuilder() = Builder().from(this)

    companion object {

        /**
         * Returns a mutable builder for constructing an instance of
         * [ResponseCodeInterpreterToolCall].
         *
         * The following fields are required:
         * ```java
         * .id()
         * .code()
         * .containerId()
         * .outputs()
         * .status()
         * ```
         */
        @JvmStatic fun builder() = Builder()
    }

    /** A builder for [ResponseCodeInterpreterToolCall]. */
    class Builder internal constructor() {

        private var id: JsonField<String>? = null
        private var code: JsonField<String>? = null
        private var containerId: JsonField<String>? = null
        private var outputs: JsonField<MutableList<Output>>? = null
        private var status: JsonField<Status>? = null
        private var type: JsonValue = JsonValue.from("code_interpreter_call")
        private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

        @JvmSynthetic
        internal fun from(responseCodeInterpreterToolCall: ResponseCodeInterpreterToolCall) =
            apply {
                id = responseCodeInterpreterToolCall.id
                code = responseCodeInterpreterToolCall.code
                containerId = responseCodeInterpreterToolCall.containerId
                outputs = responseCodeInterpreterToolCall.outputs.map { it.toMutableList() }
                status = responseCodeInterpreterToolCall.status
                type = responseCodeInterpreterToolCall.type
                additionalProperties =
                    responseCodeInterpreterToolCall.additionalProperties.toMutableMap()
            }

        /** The unique ID of the code interpreter tool call. */
        fun id(id: String) = id(JsonField.of(id))

        /**
         * Sets [Builder.id] to an arbitrary JSON value.
         *
         * You should usually call [Builder.id] with a well-typed [String] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun id(id: JsonField<String>) = apply { this.id = id }

        /** The code to run, or null if not available. */
        fun code(code: String?) = code(JsonField.ofNullable(code))

        /** Alias for calling [Builder.code] with `code.orElse(null)`. */
        fun code(code: Optional<String>) = code(code.getOrNull())

        /**
         * Sets [Builder.code] to an arbitrary JSON value.
         *
         * You should usually call [Builder.code] with a well-typed [String] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun code(code: JsonField<String>) = apply { this.code = code }

        /** The ID of the container used to run the code. */
        fun containerId(containerId: String) = containerId(JsonField.of(containerId))

        /**
         * Sets [Builder.containerId] to an arbitrary JSON value.
         *
         * You should usually call [Builder.containerId] with a well-typed [String] value instead.
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun containerId(containerId: JsonField<String>) = apply { this.containerId = containerId }

        /**
         * The outputs generated by the code interpreter, such as logs or images. Can be null if no
         * outputs are available.
         */
        fun outputs(outputs: List<Output>?) = outputs(JsonField.ofNullable(outputs))

        /** Alias for calling [Builder.outputs] with `outputs.orElse(null)`. */
        fun outputs(outputs: Optional<List<Output>>) = outputs(outputs.getOrNull())

        /**
         * Sets [Builder.outputs] to an arbitrary JSON value.
         *
         * You should usually call [Builder.outputs] with a well-typed `List<Output>` value instead.
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun outputs(outputs: JsonField<List<Output>>) = apply {
            this.outputs = outputs.map { it.toMutableList() }
        }

        /**
         * Adds a single [Output] to [outputs].
         *
         * @throws IllegalStateException if the field was previously set to a non-list.
         */
        fun addOutput(output: Output) = apply {
            outputs =
                (outputs ?: JsonField.of(mutableListOf())).also {
                    checkKnown("outputs", it).add(output)
                }
        }

        /** Alias for calling [addOutput] with `Output.ofLogs(logs)`. */
        fun addOutput(logs: Output.Logs) = addOutput(Output.ofLogs(logs))

        /**
         * Alias for calling [addOutput] with the following:
         * ```java
         * Output.Logs.builder()
         *     .logs(logs)
         *     .build()
         * ```
         */
        fun addLogsOutput(logs: String) = addOutput(Output.Logs.builder().logs(logs).build())

        /** Alias for calling [addOutput] with `Output.ofImage(image)`. */
        fun addOutput(image: Output.Image) = addOutput(Output.ofImage(image))

        /**
         * Alias for calling [addOutput] with the following:
         * ```java
         * Output.Image.builder()
         *     .url(url)
         *     .build()
         * ```
         */
        fun addImageOutput(url: String) = addOutput(Output.Image.builder().url(url).build())

        /**
         * The status of the code interpreter tool call. Valid values are `in_progress`,
         * `completed`, `incomplete`, `interpreting`, and `failed`.
         */
        fun status(status: Status) = status(JsonField.of(status))

        /**
         * Sets [Builder.status] to an arbitrary JSON value.
         *
         * You should usually call [Builder.status] with a well-typed [Status] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun status(status: JsonField<Status>) = apply { this.status = status }

        /**
         * Sets the field to an arbitrary JSON value.
         *
         * It is usually unnecessary to call this method because the field defaults to the
         * following:
         * ```java
         * JsonValue.from("code_interpreter_call")
         * ```
         *
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun type(type: JsonValue) = apply { this.type = type }

        fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
            this.additionalProperties.clear()
            putAllAdditionalProperties(additionalProperties)
        }

        fun putAdditionalProperty(key: String, value: JsonValue) = apply {
            additionalProperties.put(key, value)
        }

        fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
            this.additionalProperties.putAll(additionalProperties)
        }

        fun removeAdditionalProperty(key: String) = apply { additionalProperties.remove(key) }

        fun removeAllAdditionalProperties(keys: Set<String>) = apply {
            keys.forEach(::removeAdditionalProperty)
        }

        /**
         * Returns an immutable instance of [ResponseCodeInterpreterToolCall].
         *
         * Further updates to this [Builder] will not mutate the returned instance.
         *
         * The following fields are required:
         * ```java
         * .id()
         * .code()
         * .containerId()
         * .outputs()
         * .status()
         * ```
         *
         * @throws IllegalStateException if any required field is unset.
         */
        fun build(): ResponseCodeInterpreterToolCall =
            ResponseCodeInterpreterToolCall(
                checkRequired("id", id),
                checkRequired("code", code),
                checkRequired("containerId", containerId),
                checkRequired("outputs", outputs).map { it.toImmutable() },
                checkRequired("status", status),
                type,
                additionalProperties.toMutableMap(),
            )
    }

    private var validated: Boolean = false

    fun validate(): ResponseCodeInterpreterToolCall = apply {
        if (validated) {
            return@apply
        }

        id()
        code()
        containerId()
        outputs().ifPresent { it.forEach { it.validate() } }
        status().validate()
        _type().let {
            if (it != JsonValue.from("code_interpreter_call")) {
                throw OpenAIInvalidDataException("'type' is invalid, received $it")
            }
        }
        validated = true
    }

    fun isValid(): Boolean =
        try {
            validate()
            true
        } catch (e: OpenAIInvalidDataException) {
            false
        }

    /**
     * Returns a score indicating how many valid values are contained in this object recursively.
     *
     * Used for best match union deserialization.
     */
    @JvmSynthetic
    internal fun validity(): Int =
        (if (id.asKnown().isPresent) 1 else 0) +
            (if (code.asKnown().isPresent) 1 else 0) +
            (if (containerId.asKnown().isPresent) 1 else 0) +
            (outputs.asKnown().getOrNull()?.sumOf { it.validity().toInt() } ?: 0) +
            (status.asKnown().getOrNull()?.validity() ?: 0) +
            type.let { if (it == JsonValue.from("code_interpreter_call")) 1 else 0 }

    /** The logs output from the code interpreter. */
    @JsonDeserialize(using = Output.Deserializer::class)
    @JsonSerialize(using = Output.Serializer::class)
    class Output
    private constructor(
        private val logs: Logs? = null,
        private val image: Image? = null,
        private val _json: JsonValue? = null,
    ) {

        /** The logs output from the code interpreter. */
        fun logs(): Optional<Logs> = Optional.ofNullable(logs)

        /** The image output from the code interpreter. */
        fun image(): Optional<Image> = Optional.ofNullable(image)

        fun isLogs(): Boolean = logs != null

        fun isImage(): Boolean = image != null

        /** The logs output from the code interpreter. */
        fun asLogs(): Logs = logs.getOrThrow("logs")

        /** The image output from the code interpreter. */
        fun asImage(): Image = image.getOrThrow("image")

        fun _json(): Optional<JsonValue> = Optional.ofNullable(_json)

        fun <T> accept(visitor: Visitor<T>): T =
            when {
                logs != null -> visitor.visitLogs(logs)
                image != null -> visitor.visitImage(image)
                else -> visitor.unknown(_json)
            }

        private var validated: Boolean = false

        fun validate(): Output = apply {
            if (validated) {
                return@apply
            }

            accept(
                object : Visitor<Unit> {
                    override fun visitLogs(logs: Logs) {
                        logs.validate()
                    }

                    override fun visitImage(image: Image) {
                        image.validate()
                    }
                }
            )
            validated = true
        }

        fun isValid(): Boolean =
            try {
                validate()
                true
            } catch (e: OpenAIInvalidDataException) {
                false
            }

        /**
         * Returns a score indicating how many valid values are contained in this object
         * recursively.
         *
         * Used for best match union deserialization.
         */
        @JvmSynthetic
        internal fun validity(): Int =
            accept(
                object : Visitor<Int> {
                    override fun visitLogs(logs: Logs) = logs.validity()

                    override fun visitImage(image: Image) = image.validity()

                    override fun unknown(json: JsonValue?) = 0
                }
            )

        override fun equals(other: Any?): Boolean {
            if (this === other) {
                return true
            }

            return /* spotless:off */ other is Output && logs == other.logs && image == other.image /* spotless:on */
        }

        override fun hashCode(): Int = /* spotless:off */ Objects.hash(logs, image) /* spotless:on */

        override fun toString(): String =
            when {
                logs != null -> "Output{logs=$logs}"
                image != null -> "Output{image=$image}"
                _json != null -> "Output{_unknown=$_json}"
                else -> throw IllegalStateException("Invalid Output")
            }

        companion object {

            /** The logs output from the code interpreter. */
            @JvmStatic fun ofLogs(logs: Logs) = Output(logs = logs)

            /** The image output from the code interpreter. */
            @JvmStatic fun ofImage(image: Image) = Output(image = image)
        }

        /** An interface that defines how to map each variant of [Output] to a value of type [T]. */
        interface Visitor<out T> {

            /** The logs output from the code interpreter. */
            fun visitLogs(logs: Logs): T

            /** The image output from the code interpreter. */
            fun visitImage(image: Image): T

            /**
             * Maps an unknown variant of [Output] to a value of type [T].
             *
             * An instance of [Output] can contain an unknown variant if it was deserialized from
             * data that doesn't match any known variant. For example, if the SDK is on an older
             * version than the API, then the API may respond with new variants that the SDK is
             * unaware of.
             *
             * @throws OpenAIInvalidDataException in the default implementation.
             */
            fun unknown(json: JsonValue?): T {
                throw OpenAIInvalidDataException("Unknown Output: $json")
            }
        }

        internal class Deserializer : BaseDeserializer<Output>(Output::class) {

            override fun ObjectCodec.deserialize(node: JsonNode): Output {
                val json = JsonValue.fromJsonNode(node)
                val type = json.asObject().getOrNull()?.get("type")?.asString()?.getOrNull()

                when (type) {
                    "logs" -> {
                        return tryDeserialize(node, jacksonTypeRef<Logs>())?.let {
                            Output(logs = it, _json = json)
                        } ?: Output(_json = json)
                    }
                    "image" -> {
                        return tryDeserialize(node, jacksonTypeRef<Image>())?.let {
                            Output(image = it, _json = json)
                        } ?: Output(_json = json)
                    }
                }

                return Output(_json = json)
            }
        }

        internal class Serializer : BaseSerializer<Output>(Output::class) {

            override fun serialize(
                value: Output,
                generator: JsonGenerator,
                provider: SerializerProvider,
            ) {
                when {
                    value.logs != null -> generator.writeObject(value.logs)
                    value.image != null -> generator.writeObject(value.image)
                    value._json != null -> generator.writeObject(value._json)
                    else -> throw IllegalStateException("Invalid Output")
                }
            }
        }

        /** The logs output from the code interpreter. */
        class Logs
        private constructor(
            private val logs: JsonField<String>,
            private val type: JsonValue,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("logs") @ExcludeMissing logs: JsonField<String> = JsonMissing.of(),
                @JsonProperty("type") @ExcludeMissing type: JsonValue = JsonMissing.of(),
            ) : this(logs, type, mutableMapOf())

            /**
             * The logs output from the code interpreter.
             *
             * @throws OpenAIInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun logs(): String = logs.getRequired("logs")

            /**
             * The type of the output. Always 'logs'.
             *
             * Expected to always return the following:
             * ```java
             * JsonValue.from("logs")
             * ```
             *
             * However, this method can be useful for debugging and logging (e.g. if the server
             * responded with an unexpected value).
             */
            @JsonProperty("type") @ExcludeMissing fun _type(): JsonValue = type

            /**
             * Returns the raw JSON value of [logs].
             *
             * Unlike [logs], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("logs") @ExcludeMissing fun _logs(): JsonField<String> = logs

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of [Logs].
                 *
                 * The following fields are required:
                 * ```java
                 * .logs()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [Logs]. */
            class Builder internal constructor() {

                private var logs: JsonField<String>? = null
                private var type: JsonValue = JsonValue.from("logs")
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(logs: Logs) = apply {
                    this.logs = logs.logs
                    type = logs.type
                    additionalProperties = logs.additionalProperties.toMutableMap()
                }

                /** The logs output from the code interpreter. */
                fun logs(logs: String) = logs(JsonField.of(logs))

                /**
                 * Sets [Builder.logs] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.logs] with a well-typed [String] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun logs(logs: JsonField<String>) = apply { this.logs = logs }

                /**
                 * Sets the field to an arbitrary JSON value.
                 *
                 * It is usually unnecessary to call this method because the field defaults to the
                 * following:
                 * ```java
                 * JsonValue.from("logs")
                 * ```
                 *
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun type(type: JsonValue) = apply { this.type = type }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [Logs].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .logs()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): Logs =
                    Logs(checkRequired("logs", logs), type, additionalProperties.toMutableMap())
            }

            private var validated: Boolean = false

            fun validate(): Logs = apply {
                if (validated) {
                    return@apply
                }

                logs()
                _type().let {
                    if (it != JsonValue.from("logs")) {
                        throw OpenAIInvalidDataException("'type' is invalid, received $it")
                    }
                }
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: OpenAIInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int =
                (if (logs.asKnown().isPresent) 1 else 0) +
                    type.let { if (it == JsonValue.from("logs")) 1 else 0 }

            override fun equals(other: Any?): Boolean {
                if (this === other) {
                    return true
                }

                return /* spotless:off */ other is Logs && logs == other.logs && type == other.type && additionalProperties == other.additionalProperties /* spotless:on */
            }

            /* spotless:off */
            private val hashCode: Int by lazy { Objects.hash(logs, type, additionalProperties) }
            /* spotless:on */

            override fun hashCode(): Int = hashCode

            override fun toString() =
                "Logs{logs=$logs, type=$type, additionalProperties=$additionalProperties}"
        }

        /** The image output from the code interpreter. */
        class Image
        private constructor(
            private val type: JsonValue,
            private val url: JsonField<String>,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("type") @ExcludeMissing type: JsonValue = JsonMissing.of(),
                @JsonProperty("url") @ExcludeMissing url: JsonField<String> = JsonMissing.of(),
            ) : this(type, url, mutableMapOf())

            /**
             * The type of the output. Always 'image'.
             *
             * Expected to always return the following:
             * ```java
             * JsonValue.from("image")
             * ```
             *
             * However, this method can be useful for debugging and logging (e.g. if the server
             * responded with an unexpected value).
             */
            @JsonProperty("type") @ExcludeMissing fun _type(): JsonValue = type

            /**
             * The URL of the image output from the code interpreter.
             *
             * @throws OpenAIInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun url(): String = url.getRequired("url")

            /**
             * Returns the raw JSON value of [url].
             *
             * Unlike [url], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("url") @ExcludeMissing fun _url(): JsonField<String> = url

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of [Image].
                 *
                 * The following fields are required:
                 * ```java
                 * .url()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [Image]. */
            class Builder internal constructor() {

                private var type: JsonValue = JsonValue.from("image")
                private var url: JsonField<String>? = null
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(image: Image) = apply {
                    type = image.type
                    url = image.url
                    additionalProperties = image.additionalProperties.toMutableMap()
                }

                /**
                 * Sets the field to an arbitrary JSON value.
                 *
                 * It is usually unnecessary to call this method because the field defaults to the
                 * following:
                 * ```java
                 * JsonValue.from("image")
                 * ```
                 *
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun type(type: JsonValue) = apply { this.type = type }

                /** The URL of the image output from the code interpreter. */
                fun url(url: String) = url(JsonField.of(url))

                /**
                 * Sets [Builder.url] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.url] with a well-typed [String] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun url(url: JsonField<String>) = apply { this.url = url }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [Image].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .url()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): Image =
                    Image(type, checkRequired("url", url), additionalProperties.toMutableMap())
            }

            private var validated: Boolean = false

            fun validate(): Image = apply {
                if (validated) {
                    return@apply
                }

                _type().let {
                    if (it != JsonValue.from("image")) {
                        throw OpenAIInvalidDataException("'type' is invalid, received $it")
                    }
                }
                url()
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: OpenAIInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int =
                type.let { if (it == JsonValue.from("image")) 1 else 0 } +
                    (if (url.asKnown().isPresent) 1 else 0)

            override fun equals(other: Any?): Boolean {
                if (this === other) {
                    return true
                }

                return /* spotless:off */ other is Image && type == other.type && url == other.url && additionalProperties == other.additionalProperties /* spotless:on */
            }

            /* spotless:off */
            private val hashCode: Int by lazy { Objects.hash(type, url, additionalProperties) }
            /* spotless:on */

            override fun hashCode(): Int = hashCode

            override fun toString() =
                "Image{type=$type, url=$url, additionalProperties=$additionalProperties}"
        }
    }

    /**
     * The status of the code interpreter tool call. Valid values are `in_progress`, `completed`,
     * `incomplete`, `interpreting`, and `failed`.
     */
    class Status @JsonCreator private constructor(private val value: JsonField<String>) : Enum {

        /**
         * Returns this class instance's raw value.
         *
         * This is usually only useful if this instance was deserialized from data that doesn't
         * match any known member, and you want to know that value. For example, if the SDK is on an
         * older version than the API, then the API may respond with new members that the SDK is
         * unaware of.
         */
        @com.fasterxml.jackson.annotation.JsonValue fun _value(): JsonField<String> = value

        companion object {

            @JvmField val IN_PROGRESS = of("in_progress")

            @JvmField val COMPLETED = of("completed")

            @JvmField val INCOMPLETE = of("incomplete")

            @JvmField val INTERPRETING = of("interpreting")

            @JvmField val FAILED = of("failed")

            @JvmStatic fun of(value: String) = Status(JsonField.of(value))
        }

        /** An enum containing [Status]'s known values. */
        enum class Known {
            IN_PROGRESS,
            COMPLETED,
            INCOMPLETE,
            INTERPRETING,
            FAILED,
        }

        /**
         * An enum containing [Status]'s known values, as well as an [_UNKNOWN] member.
         *
         * An instance of [Status] can contain an unknown value in a couple of cases:
         * - It was deserialized from data that doesn't match any known member. For example, if the
         *   SDK is on an older version than the API, then the API may respond with new members that
         *   the SDK is unaware of.
         * - It was constructed with an arbitrary value using the [of] method.
         */
        enum class Value {
            IN_PROGRESS,
            COMPLETED,
            INCOMPLETE,
            INTERPRETING,
            FAILED,
            /** An enum member indicating that [Status] was instantiated with an unknown value. */
            _UNKNOWN,
        }

        /**
         * Returns an enum member corresponding to this class instance's value, or [Value._UNKNOWN]
         * if the class was instantiated with an unknown value.
         *
         * Use the [known] method instead if you're certain the value is always known or if you want
         * to throw for the unknown case.
         */
        fun value(): Value =
            when (this) {
                IN_PROGRESS -> Value.IN_PROGRESS
                COMPLETED -> Value.COMPLETED
                INCOMPLETE -> Value.INCOMPLETE
                INTERPRETING -> Value.INTERPRETING
                FAILED -> Value.FAILED
                else -> Value._UNKNOWN
            }

        /**
         * Returns an enum member corresponding to this class instance's value.
         *
         * Use the [value] method instead if you're uncertain the value is always known and don't
         * want to throw for the unknown case.
         *
         * @throws OpenAIInvalidDataException if this class instance's value is a not a known
         *   member.
         */
        fun known(): Known =
            when (this) {
                IN_PROGRESS -> Known.IN_PROGRESS
                COMPLETED -> Known.COMPLETED
                INCOMPLETE -> Known.INCOMPLETE
                INTERPRETING -> Known.INTERPRETING
                FAILED -> Known.FAILED
                else -> throw OpenAIInvalidDataException("Unknown Status: $value")
            }

        /**
         * Returns this class instance's primitive wire representation.
         *
         * This differs from the [toString] method because that method is primarily for debugging
         * and generally doesn't throw.
         *
         * @throws OpenAIInvalidDataException if this class instance's value does not have the
         *   expected primitive type.
         */
        fun asString(): String =
            _value().asString().orElseThrow { OpenAIInvalidDataException("Value is not a String") }

        private var validated: Boolean = false

        fun validate(): Status = apply {
            if (validated) {
                return@apply
            }

            known()
            validated = true
        }

        fun isValid(): Boolean =
            try {
                validate()
                true
            } catch (e: OpenAIInvalidDataException) {
                false
            }

        /**
         * Returns a score indicating how many valid values are contained in this object
         * recursively.
         *
         * Used for best match union deserialization.
         */
        @JvmSynthetic internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

        override fun equals(other: Any?): Boolean {
            if (this === other) {
                return true
            }

            return /* spotless:off */ other is Status && value == other.value /* spotless:on */
        }

        override fun hashCode() = value.hashCode()

        override fun toString() = value.toString()
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) {
            return true
        }

        return /* spotless:off */ other is ResponseCodeInterpreterToolCall && id == other.id && code == other.code && containerId == other.containerId && outputs == other.outputs && status == other.status && type == other.type && additionalProperties == other.additionalProperties /* spotless:on */
    }

    /* spotless:off */
    private val hashCode: Int by lazy { Objects.hash(id, code, containerId, outputs, status, type, additionalProperties) }
    /* spotless:on */

    override fun hashCode(): Int = hashCode

    override fun toString() =
        "ResponseCodeInterpreterToolCall{id=$id, code=$code, containerId=$containerId, outputs=$outputs, status=$status, type=$type, additionalProperties=$additionalProperties}"
}
