/*
 * Decompiled with CFR 0.152.
 */
package com.openai.services.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.openai.core.ClientOptions;
import com.openai.errors.InvalidWebhookSignatureException;
import com.openai.errors.OpenAIInvalidDataException;
import com.openai.models.webhooks.UnwrapWebhookEvent;
import com.openai.models.webhooks.WebhookVerificationParams;
import com.openai.services.blocking.WebhookService;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0011\u001a\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/openai/services/blocking/WebhookServiceImpl;", "Lcom/openai/services/blocking/WebhookService;", "clientOptions", "Lcom/openai/core/ClientOptions;", "(Lcom/openai/core/ClientOptions;)V", "withRawResponse", "Lcom/openai/services/blocking/WebhookService$WithRawResponse;", "getWithRawResponse", "()Lcom/openai/services/blocking/WebhookService$WithRawResponse;", "withRawResponse$delegate", "Lkotlin/Lazy;", "unwrap", "Lcom/openai/models/webhooks/UnwrapWebhookEvent;", "params", "Lcom/openai/models/webhooks/WebhookVerificationParams;", "verifySignature", "", "withOptions", "modifier", "Ljava/util/function/Consumer;", "Lcom/openai/core/ClientOptions$Builder;", "WithRawResponseImpl", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nWebhookServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebhookServiceImpl.kt\ncom/openai/services/blocking/WebhookServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1#2:144\n43#3:145\n1549#4:146\n1620#4,3:147\n1747#4,3:150\n*S KotlinDebug\n*F\n+ 1 WebhookServiceImpl.kt\ncom/openai/services/blocking/WebhookServiceImpl\n*L\n43#1:145\n98#1:146\n98#1:147,3\n121#1:150,3\n*E\n"})
public final class WebhookServiceImpl
implements WebhookService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final Lazy withRawResponse$delegate;

    public WebhookServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.withRawResponse$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WithRawResponseImpl>(this){
            final /* synthetic */ WebhookServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final WithRawResponseImpl invoke() {
                return new WithRawResponseImpl(WebhookServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
    }

    private final WebhookService.WithRawResponse getWithRawResponse() {
        Lazy lazy = this.withRawResponse$delegate;
        return (WebhookService.WithRawResponse)lazy.getValue();
    }

    @Override
    @NotNull
    public WebhookService.WithRawResponse withRawResponse() {
        return this.getWithRawResponse();
    }

    @Override
    @NotNull
    public WebhookService withOptions(@NotNull Consumer<ClientOptions.Builder> modifier) {
        ClientOptions.Builder builder;
        Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
        ClientOptions.Builder p0 = builder = this.clientOptions.toBuilder();
        boolean bl = false;
        modifier.accept(p0);
        ClientOptions clientOptions = builder.build();
        return new WebhookServiceImpl(clientOptions);
    }

    @Override
    @NotNull
    public UnwrapWebhookEvent unwrap(@NotNull WebhookVerificationParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.verifySignature(params);
        Object object = params.payload();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String bodyString = new String((byte[])object, charset2);
        try {
            boolean $i$f$jacksonTypeRef = false;
            Object object2 = this.clientOptions.jsonMapper().readValue(bodyString, (TypeReference)new TypeReference<UnwrapWebhookEvent>(){});
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n            clientOpti\u2026ebhookEvent>())\n        }");
            object = (UnwrapWebhookEvent)object2;
        }
        catch (Exception e) {
            throw new OpenAIInvalidDataException("Error parsing body", e);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void verifySignature(@NotNull WebhookVerificationParams params) {
        boolean signatureMatches;
        block16: {
            boolean bl;
            byte[] byArray;
            byte[] $this$mapTo$iv$iv;
            long l;
            String string;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            String string2 = params.secret().orElse(null);
            if (string2 == null) {
                string2 = this.clientOptions.webhookSecret().orElse(null);
            }
            if ((string = string2) == null) {
                throw new IllegalStateException("The webhook secret must either be set using the env var, OPENAI_WEBHOOK_SECRET, on the client class builder, .webhookSecret(...), or passed to this function");
            }
            String webhookSecret = string;
            String string3 = (String)CollectionsKt.firstOrNull(params.headers().values("webhook-signature"));
            if (string3 == null) {
                throw new IllegalArgumentException("Missing required webhook-signature header");
            }
            String signatureHeader = string3;
            String string4 = (String)CollectionsKt.firstOrNull(params.headers().values("webhook-timestamp"));
            if (string4 == null) {
                throw new IllegalArgumentException("Missing required webhook-timestamp header");
            }
            String timestampHeader = string4;
            String string5 = (String)CollectionsKt.firstOrNull(params.headers().values("webhook-id"));
            if (string5 == null) {
                throw new IllegalArgumentException("Missing required webhook-id header");
            }
            String webhookId = string5;
            try {
                l = Long.parseLong(timestampHeader);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid webhook timestamp format", e);
            }
            long timestampSeconds = l;
            Instant now = Instant.now(this.clientOptions.clock());
            Instant timestampInstant = Instant.ofEpochSecond(timestampSeconds);
            Duration toleranceDuration = params.tolerance();
            if (timestampInstant.isBefore(now.minus(toleranceDuration))) {
                throw new InvalidWebhookSignatureException("Webhook timestamp is too old", null, 2, null);
            }
            if (timestampInstant.isAfter(now.plus(toleranceDuration))) {
                throw new InvalidWebhookSignatureException("Webhook timestamp is too new", null, 2, null);
            }
            String[] stringArray = new String[]{" "};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)signatureHeader, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void it;
                String string6 = (String)t;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(StringsKt.removePrefix((String)it, (CharSequence)"v1,"));
            }
            List signatures = (List)destination$iv$iv;
            if (StringsKt.startsWith$default((String)webhookSecret, (String)"whsec_", (boolean)false, (int)2, null)) {
                Base64.Decoder decoder = Base64.getDecoder();
                String string7 = webhookSecret.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                byArray = decoder.decode(string7);
            } else {
                String $i$f$map22 = webhookSecret;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray2 = $i$f$map22.getBytes(charset);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            }
            byte[] decodedSecret = byArray;
            $this$mapTo$iv$iv = params.payload();
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            destination$iv$iv = charset;
            String bodyString = new String($this$mapTo$iv$iv, (Charset)destination$iv$iv);
            String signedPayload = webhookId + '.' + timestampHeader + '.' + bodyString;
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(decodedSecret, "HmacSHA256");
            mac.init(secretKey);
            String string8 = signedPayload;
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            byte[] byArray3 = string8.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
            byte[] expectedSignatureBytes = mac.doFinal(byArray3);
            String string9 = Base64.getEncoder().encodeToString(expectedSignatureBytes);
            Iterable $this$any$iv = signatures;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String signature = (String)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"expectedSignature");
                    byte[] byArray4 = string9.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"this as java.lang.String).getBytes(charset)");
                    byte[] byArray5 = signature.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"this as java.lang.String).getBytes(charset)");
                    if (!MessageDigest.isEqual(byArray4, byArray5)) continue;
                    bl = true;
                    break block16;
                }
                bl = signatureMatches = false;
            }
        }
        if (!signatureMatches) {
            throw new InvalidWebhookSignatureException("The given webhook signature does not match the expected signature", null, 2, null);
        }
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(WebhookServiceImpl $this) {
        return $this.clientOptions;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/openai/services/blocking/WebhookServiceImpl$WithRawResponseImpl;", "Lcom/openai/services/blocking/WebhookService$WithRawResponse;", "clientOptions", "Lcom/openai/core/ClientOptions;", "(Lcom/openai/core/ClientOptions;)V", "withOptions", "modifier", "Ljava/util/function/Consumer;", "Lcom/openai/core/ClientOptions$Builder;", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nWebhookServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebhookServiceImpl.kt\ncom/openai/services/blocking/WebhookServiceImpl$WithRawResponseImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
    public static final class WithRawResponseImpl
    implements WebhookService.WithRawResponse {
        @NotNull
        private final ClientOptions clientOptions;

        public WithRawResponseImpl(@NotNull ClientOptions clientOptions) {
            Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
            this.clientOptions = clientOptions;
        }

        @Override
        @NotNull
        public WebhookService.WithRawResponse withOptions(@NotNull Consumer<ClientOptions.Builder> modifier) {
            ClientOptions.Builder builder;
            Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
            ClientOptions.Builder p0 = builder = this.clientOptions.toBuilder();
            boolean bl = false;
            modifier.accept(p0);
            ClientOptions clientOptions = builder.build();
            return new WithRawResponseImpl(clientOptions);
        }
    }
}

