/*
 * Decompiled with CFR 0.152.
 */
package com.opencagedata.jopencage;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opencagedata.jopencage.model.JOpenCageForwardRequest;
import com.opencagedata.jopencage.model.JOpenCageRequest;
import com.opencagedata.jopencage.model.JOpenCageResponse;
import com.opencagedata.jopencage.model.JOpenCageReverseRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.AbstractHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JOpenCageGeocoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JOpenCageGeocoder.class);
    private static final String OPENCAGE_HOST = "api.opencagedata.com";
    private static final String OPENCAGE_PATH = "/geocode/v1/";
    private boolean httpsEnabled = true;
    private String host = "api.opencagedata.com";
    private String path = "/geocode/v1/";
    private String format = "json";
    private String apiKey;
    private String userAgent;

    public JOpenCageGeocoder(String apiKey) {
        this.apiKey = apiKey;
        String packageVersion = this.getClass().getPackage().getImplementationVersion();
        StringBuilder userAgentBuilder = new StringBuilder("jOpenCage/");
        if (packageVersion != null) {
            userAgentBuilder.append(packageVersion);
        }
        this.userAgent = userAgentBuilder.toString();
    }

    public JOpenCageResponse forward(JOpenCageForwardRequest request) {
        return this.sendRequest(request);
    }

    public JOpenCageResponse reverse(JOpenCageReverseRequest request) {
        return this.sendRequest(request);
    }

    public URI buildUri(JOpenCageRequest jOpenCageRequest) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder();
        if (this.httpsEnabled) {
            uriBuilder.setScheme("https");
        } else {
            uriBuilder.setScheme("http");
        }
        uriBuilder.setHost(this.host).setPath(this.path + this.format);
        for (Map.Entry<String, String> e : jOpenCageRequest.getParameter().entrySet()) {
            if (e.getValue() == null) continue;
            uriBuilder.setParameter(e.getKey(), e.getValue());
        }
        uriBuilder.setParameter("key", this.apiKey);
        return uriBuilder.build();
    }

    private JOpenCageResponse sendRequest(JOpenCageRequest jOpenCageRequest) {
        URI url = null;
        try {
            url = this.buildUri(jOpenCageRequest);
            LOGGER.info("JOpencage request url '{}'", (Object)url);
        }
        catch (URISyntaxException e1) {
            LOGGER.error("", (Throwable)e1);
        }
        if (url != null) {
            JOpenCageResponse jOpenCageResponse;
            block21: {
                CloseableHttpClient httpclient = HttpClientBuilder.create().build();
                try {
                    HttpGet getRequest = new HttpGet(url);
                    getRequest.setHeader("User-Agent", (Object)this.userAgent);
                    AbstractHttpClientResponseHandler<JOpenCageResponse> rh = new AbstractHttpClientResponseHandler<JOpenCageResponse>(){

                        public JOpenCageResponse handleEntity(HttpEntity entity) throws IOException {
                            ObjectMapper mapper = new ObjectMapper();
                            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                            return (JOpenCageResponse)mapper.readValue(entity.getContent(), JOpenCageResponse.class);
                        }
                    };
                    jOpenCageResponse = (JOpenCageResponse)httpclient.execute((ClassicHttpRequest)getRequest, (HttpClientResponseHandler)rh);
                    if (httpclient == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        if (httpclient != null) {
                            try {
                                httpclient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (HttpResponseException e) {
                        switch (e.getStatusCode()) {
                            case 400: {
                                LOGGER.error("Invalid request (bad request; a required parameter is missing)!");
                                break;
                            }
                            case 402: {
                                LOGGER.error("Valid request but quota exceeded (payment required)!");
                                break;
                            }
                            case 403: {
                                LOGGER.error("Invalid or missing api key!");
                                break;
                            }
                            case 404: {
                                LOGGER.error("Invalid API endpoint!");
                                break;
                            }
                            case 408: {
                                LOGGER.error("Timeout; you can try again!");
                                break;
                            }
                            case 410: {
                                LOGGER.error("Request too long!");
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                }
                httpclient.close();
            }
            return jOpenCageResponse;
        } else {
            LOGGER.error("No jopencage request url build!");
        }
        return null;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public void setHttpsEnabled(boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getApiKey() {
        return this.apiKey;
    }
}

