/*
 * Decompiled with CFR 0.152.
 */
package com.opencagedata.jopencage.model;

import com.opencagedata.jopencage.model.JOpenCageRequest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;

public class JOpenCageReverseRequest
extends JOpenCageRequest {
    private static final ThreadLocal<DecimalFormat> FORMATTER = ThreadLocal.withInitial(() -> {
        DecimalFormat decimalFormat = new DecimalFormat("##.#######");
        decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        return decimalFormat;
    });
    private final Double latitude;
    private final Double longitude;

    public JOpenCageReverseRequest(Double latitude, Double longitude) {
        if (latitude == null || longitude == null) {
            throw new IllegalArgumentException("Both latitude and longitude must not be null!");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @Override
    public Map<String, String> getParameter() {
        Map<String, String> parameter = super.getParameter();
        DecimalFormat decimalFormat = FORMATTER.get();
        parameter.put("q", decimalFormat.format(this.latitude) + " " + decimalFormat.format(this.longitude));
        return parameter;
    }
}

