/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.resource.impl;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.impl.ActivityState;
import com.opencloud.sleetck.lib.resource.impl.TCKResourceEventImpl;
import com.opencloud.sleetck.lib.resource.impl.TCKResourceImpl;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.slee.Address;

public class TCKResourceTestInterfaceImpl
extends UnicastRemoteObject
implements TCKResourceTestInterface {
    private TCKResourceImpl resource;
    private Map activityMap;
    private TCKResourceListener resourceListener;

    public TCKResourceTestInterfaceImpl(TCKResourceImpl tCKResourceImpl, Map map) throws RemoteException {
        this.resource = tCKResourceImpl;
        this.activityMap = map;
    }

    public TCKActivityID createActivity(String string) throws TCKTestErrorException, RemoteException {
        return this.resource.createAndRegisterActivity(string);
    }

    public void endActivity(TCKActivityID tCKActivityID) throws TCKTestErrorException, RemoteException {
        this.resource.markActivityEnded(tCKActivityID);
        this.resource.getEventDelegator().handleActivityEnd(tCKActivityID, false);
    }

    public boolean isLive(TCKActivityID tCKActivityID) throws TCKTestErrorException, RemoteException {
        return this.resource.isLive(tCKActivityID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAllActivities() throws TCKTestErrorException, RemoteException {
        Iterator iterator;
        Object object = this.activityMap;
        synchronized (object) {
            iterator = new HashSet(this.activityMap.keySet()).iterator();
        }
        while (iterator.hasNext()) {
            object = (TCKActivityID)iterator.next();
            if (!this.isLive((TCKActivityID)object)) continue;
            this.endActivity((TCKActivityID)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeActivites() throws TCKTestErrorException, RemoteException {
        Map map = this.activityMap;
        synchronized (map) {
            Iterator iterator = new HashSet(this.activityMap.keySet()).iterator();
            while (iterator.hasNext()) {
                TCKActivityID tCKActivityID = (TCKActivityID)iterator.next();
                if (this.isLive(tCKActivityID)) continue;
                this.activityMap.remove(tCKActivityID);
            }
        }
    }

    public void clearActivities() throws TCKTestErrorException, RemoteException {
        this.endAllActivities();
        this.purgeActivites();
        this.resource.getEventDelegator().onActivitiesCleared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(long l, String string, Object object, TCKActivityID tCKActivityID, Address address) throws TCKTestErrorException, RemoteException {
        ActivityState activityState = null;
        Object object2 = this.activityMap;
        synchronized (object2) {
            activityState = (ActivityState)this.activityMap.get(tCKActivityID);
        }
        if (activityState == null) {
            throw new TCKTestErrorException("Can't fire event on an unknown activity: " + tCKActivityID);
        }
        object2 = activityState;
        synchronized (object2) {
            if (!activityState.isLive()) {
                throw new TCKTestErrorException("Can't fire event on an ended activity: " + tCKActivityID);
            }
            TCKResourceEventImpl tCKResourceEventImpl = new TCKResourceEventImpl(l, string, object, activityState.getActivityInterface());
            this.resource.getEventDelegator().handleEvent(tCKResourceEventImpl, string, tCKActivityID, address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fireEvent(String string, Object object, TCKActivityID tCKActivityID, Address address) throws TCKTestErrorException, RemoteException {
        ActivityState activityState = null;
        Object object2 = this.activityMap;
        synchronized (object2) {
            activityState = (ActivityState)this.activityMap.get(tCKActivityID);
        }
        if (activityState == null) {
            throw new TCKTestErrorException("Can't fire event on an unknown activity: " + tCKActivityID);
        }
        object2 = activityState;
        synchronized (object2) {
            if (!activityState.isLive()) {
                throw new TCKTestErrorException("Can't fire event on an ended activity: " + tCKActivityID);
            }
            long l = this.resource.nextEventOID();
            TCKResourceEventImpl tCKResourceEventImpl = new TCKResourceEventImpl(l, string, object, activityState.getActivityInterface());
            this.resource.getEventDelegator().handleEvent(tCKResourceEventImpl, string, tCKActivityID, address);
            return l;
        }
    }

    public void setResourceListener(TCKResourceListener tCKResourceListener) throws TCKTestErrorException {
        this.resourceListener = tCKResourceListener;
    }

    public void removeResourceListener() throws TCKTestErrorException {
        this.resourceListener = null;
    }

    TCKResourceListener getResourceListener() {
        return this.resourceListener;
    }
}

