/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.infra.testfinder;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.infra.testfinder.NotATestDescriptionException;
import com.opencloud.sleetck.lib.infra.testfinder.TestDescriptionFileHandler;
import com.sun.javatest.TestDescription;
import java.io.File;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TestDescriptionReader {
    private TestDescriptionFileHandler fileHandler;
    private XMLReader reader;
    private File testSuiteRoot;

    public TestDescriptionReader(File file, String string) throws SAXException {
        this.testSuiteRoot = file;
        this.reader = XMLReaderFactory.createXMLReader();
        this.fileHandler = new TestDescriptionFileHandler(string);
        this.reader.setContentHandler(this.fileHandler);
        this.reader.setDTDHandler(this.fileHandler);
        this.reader.setEntityResolver(this.fileHandler);
        this.reader.setErrorHandler(this.fileHandler);
    }

    public TestDescription readTestDescription(File file) throws TCKTestErrorException {
        TestDescription testDescription;
        block3: {
            testDescription = null;
            if (file.getPath().endsWith(".xml")) {
                try {
                    this.reader.parse(file.toURL().toExternalForm());
                    Map map = this.fileHandler.getTestParameters();
                    testDescription = new TestDescription(this.testSuiteRoot, file, map);
                }
                catch (Exception exception) {
                    if (exception instanceof SAXException && ((SAXException)exception).getException() instanceof NotATestDescriptionException) break block3;
                    throw new TCKTestErrorException("Caught unexpected error while trying to read a test description", exception);
                }
            }
        }
        return testDescription;
    }
}

