/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.rautils;

import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.rautils.TraceLogger;
import com.opencloud.sleetck.lib.rautils.UOID;
import com.opencloud.sleetck.lib.resource.adaptor11.TCKActivityHandleImpl;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleSbbInterface;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.slee.Address;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;

public abstract class BaseTCKRA
implements ResourceAdaptor,
SimpleSbbInterface {
    private ResourceAdaptorContext resourceAdaptorContext;
    private RMIObjectChannel out;
    private UOID rauid;
    private TraceLogger traceLogger = new TraceLogger();

    protected BaseTCKRA() {
        this.rauid = UOID.createUOID();
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
        }
        catch (Exception exception) {
            this.out = null;
            this.getLog().severe("An error occured creating the RMIObjectChannel for RA Object: " + this.rauid, exception);
        }
    }

    protected void sendMessage(final Object object) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (BaseTCKRA.this.out == null) {
                    BaseTCKRA.this.getLog().severe("Attempted to write to the RMIObjectChannel before it was initialized: rauid=" + BaseTCKRA.this.rauid + ", message=" + object);
                    return null;
                }
                try {
                    BaseTCKRA.this.out.writeObject(object);
                }
                catch (RemoteException remoteException) {
                    BaseTCKRA.this.getLog().severe("An error occured writing to the RMIObjectChannel for RA Object: " + BaseTCKRA.this.rauid, remoteException);
                }
                return null;
            }
        });
    }

    public Object getResourceAdaptorInterface(String string) {
        if (string.equals("com.opencloud.sleetck.lib.testsuite.resource.SimpleSbbInterface")) {
            return this;
        }
        return null;
    }

    public void executeTestLogic(Object object) throws Exception {
    }

    public Object getActivity(ActivityHandle activityHandle) {
        if (activityHandle instanceof TCKActivityHandleImpl) {
            return (TCKActivityHandleImpl)activityHandle;
        }
        return null;
    }

    public ActivityHandle getActivityHandle(Object object) {
        if (object instanceof TCKActivityHandleImpl) {
            return (ActivityHandle)object;
        }
        return null;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext resourceAdaptorContext) {
        this.resourceAdaptorContext = resourceAdaptorContext;
    }

    public void unsetResourceAdaptorContext() {
        this.resourceAdaptorContext = null;
    }

    public void activityEnded(ActivityHandle activityHandle) {
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
    }

    public void administrativeRemove(ActivityHandle activityHandle) {
    }

    public void raConfigurationUpdate(ConfigProperties configProperties) {
    }

    public void raConfigure(ConfigProperties configProperties) {
    }

    public void raUnconfigure() {
    }

    public void raActive() {
    }

    public void raInactive() {
    }

    public void raStopping() {
    }

    public void raVerifyConfiguration(ConfigProperties configProperties) throws InvalidConfigurationException {
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, FireableEventType fireableEventType, Object object, Address address, ReceivableService receivableService, int n, FailureReason failureReason) {
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, FireableEventType fireableEventType, Object object, Address address, ReceivableService receivableService, int n) {
    }

    public void eventUnreferenced(ActivityHandle activityHandle, FireableEventType fireableEventType, Object object, Address address, ReceivableService receivableService, int n) {
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void queryLiveness(ActivityHandle activityHandle) {
    }

    public void serviceActive(ReceivableService receivableService) {
    }

    public void serviceInactive(ReceivableService receivableService) {
    }

    public void serviceStopping(ReceivableService receivableService) {
    }

    public void sendSbbMessage(Object object) {
        this.sendMessage(object);
    }

    public void logTestString(String string) {
        this.getLog().info("Received log message from SBB: " + string);
    }

    public ResourceAdaptorContext getResourceAdaptorContext() {
        return this.resourceAdaptorContext;
    }

    public ConfigProperties sanitizeConfigProperties(ConfigProperties configProperties) {
        ConfigProperties configProperties2 = new ConfigProperties();
        ConfigProperties.Property[] propertyArray = configProperties.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i].getName() != null && propertyArray[i].getName().startsWith("slee-vendor:")) continue;
            configProperties2.addProperty(propertyArray[i]);
        }
        return configProperties2;
    }

    protected void setTracer(Tracer tracer) {
        this.traceLogger.setTracer(tracer);
    }

    protected TraceLogger getLog() {
        return this.traceLogger;
    }

    protected UOID getRAUID() {
        return this.rauid;
    }
}

