/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.rautils;

import javax.slee.facilities.FacilityException;
import javax.slee.facilities.TraceLevel;
import javax.slee.facilities.Tracer;

public class TraceLogger {
    private Tracer tracer;

    public void config(String string) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.CONFIG, string);
    }

    public void config(String string, Throwable throwable) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.CONFIG, string, throwable);
    }

    public void fine(String string) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.FINE, string);
    }

    public void fine(String string, Throwable throwable) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.FINE, string, throwable);
    }

    public void finer(String string) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.FINER, string);
    }

    public void finer(String string, Throwable throwable) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.FINER, string, throwable);
    }

    public void finest(String string) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.FINEST, string);
    }

    public void finest(String string, Throwable throwable) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.FINEST, string, throwable);
    }

    public void info(String string) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.INFO, string);
    }

    public void info(String string, Throwable throwable) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.INFO, string, throwable);
    }

    public void severe(String string) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.SEVERE, string);
    }

    public void severe(String string, Throwable throwable) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.SEVERE, string, throwable);
    }

    public void warning(String string) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.WARNING, string);
    }

    public void warning(String string, Throwable throwable) throws NullPointerException, FacilityException {
        this.trace(TraceLevel.WARNING, string, throwable);
    }

    public boolean isFineEnabled() throws FacilityException {
        if (this.tracer != null) {
            return this.tracer.isFineEnabled();
        }
        return true;
    }

    public boolean isFinerEnabled() throws FacilityException {
        if (this.tracer != null) {
            return this.tracer.isFinerEnabled();
        }
        return true;
    }

    public boolean isFinestEnabled() throws FacilityException {
        if (this.tracer != null) {
            return this.tracer.isFinestEnabled();
        }
        return true;
    }

    public boolean isInfoEnabled() throws FacilityException {
        if (this.tracer != null) {
            return this.tracer.isInfoEnabled();
        }
        return true;
    }

    public boolean isSevereEnabled() throws FacilityException {
        if (this.tracer != null) {
            return this.tracer.isSevereEnabled();
        }
        return true;
    }

    public boolean isWarningEnabled() throws FacilityException {
        if (this.tracer != null) {
            return this.tracer.isWarningEnabled();
        }
        return true;
    }

    public void trace(TraceLevel traceLevel, String string) throws NullPointerException, IllegalArgumentException, FacilityException {
        if (this.tracer == null) {
            System.err.println("TCKTraceLogger [" + traceLevel.toString() + "] " + string);
        } else {
            this.tracer.trace(traceLevel, string);
        }
    }

    public void trace(TraceLevel traceLevel, String string, Throwable throwable) throws NullPointerException, IllegalArgumentException, FacilityException {
        if (this.tracer == null) {
            System.err.println("TCKTraceLogger [" + traceLevel.toString() + "] " + string);
            throwable.printStackTrace(System.err);
        } else {
            this.tracer.trace(traceLevel, string, throwable);
        }
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }
}

