/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.resource.impl;

import com.opencloud.logging.Logable;
import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKTestCallException;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceAdaptorInterface;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceEventHandler;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceSetupInterface;
import com.opencloud.sleetck.lib.resource.impl.ActivityState;
import com.opencloud.sleetck.lib.resource.impl.EventDelegator;
import com.opencloud.sleetck.lib.resource.impl.EventDelegatorImpl;
import com.opencloud.sleetck.lib.resource.impl.TCKActivityIDImpl;
import com.opencloud.sleetck.lib.resource.impl.TCKActivityImpl;
import com.opencloud.sleetck.lib.resource.impl.TCKResourceActivityInterface;
import com.opencloud.sleetck.lib.resource.impl.TCKResourceTestInterfaceImpl;
import com.opencloud.sleetck.lib.resource.impl.TCKSbbMessageImpl;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKActivity;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKResourceSbbInterface;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;

public class TCKResourceImpl
extends UnicastRemoteObject
implements TCKResourceSetupInterface,
TCKResourceAdaptorInterface,
TCKResourceSbbInterface,
TCKResourceActivityInterface {
    private EventDelegatorImpl eventDelegator;
    private TCKResourceTestInterfaceImpl testInterfaceImpl;
    private HashMap activityMap;
    private Logable log = new StdErrLog();
    private static long eventOIDCounter = 0L;
    private static long activityOIDCounter = 0L;

    public TCKResourceImpl() throws RemoteException {
        this.activityMap = new HashMap();
        this.testInterfaceImpl = new TCKResourceTestInterfaceImpl(this, this.activityMap);
        this.eventDelegator = new EventDelegatorImpl(this.log);
    }

    public void setLog(Logable logable) {
        this.log = logable;
        this.eventDelegator.setLog(logable);
    }

    public TCKResourceTestInterface getTestInterface() throws TCKTestErrorException {
        return this.testInterfaceImpl;
    }

    public TCKResourceAdaptorInterface getResourceAdaptorInterface() throws TCKTestErrorException {
        return this;
    }

    public void addEventHandler(TCKResourceEventHandler tCKResourceEventHandler) {
        this.eventDelegator.addEventHandler(tCKResourceEventHandler);
    }

    public void eventHandlerDeactivating(TCKResourceEventHandler tCKResourceEventHandler) {
        this.eventDelegator.eventHandlerDeactivating(tCKResourceEventHandler);
    }

    public void removeEventHandler(TCKResourceEventHandler tCKResourceEventHandler) {
        this.eventDelegator.removeEventHandler(tCKResourceEventHandler);
    }

    public TCKResourceSbbInterface getSbbInterface() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityContextInvalid(TCKActivityID tCKActivityID) {
        try {
            boolean bl = false;
            Object object = this.activityMap;
            synchronized (object) {
                bl = this.activityMap.get(tCKActivityID) != null;
            }
            if (bl) {
                object = this.getResourceListener();
                if (object != null) {
                    object.onActivityContextInvalid(tCKActivityID);
                } else {
                    this.log.warning("No listener set during onActivityContextInvalid() call");
                }
            } else {
                this.log.finer("Ignoring onActivityContextInvalid call for non-registered activity");
            }
        }
        catch (RemoteException remoteException) {
            this.handleFailedNotification(remoteException);
        }
    }

    public void onException(final Exception exception) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    TCKResourceListener tCKResourceListener = TCKResourceImpl.this.getResourceListener();
                    if (tCKResourceListener != null) {
                        tCKResourceListener.onException(exception);
                    } else {
                        TCKResourceImpl.this.log.warning(exception);
                        TCKResourceImpl.this.log.warning("No listener set during onException() call");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.handleFailedNotification((RemoteException)privilegedActionException.getException());
        }
    }

    public void onEventProcessingSuccessful(final long l) throws RemoteException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    TCKResourceListener tCKResourceListener = TCKResourceImpl.this.getResourceListener();
                    if (tCKResourceListener != null) {
                        tCKResourceListener.onEventProcessingSuccessful(l);
                    } else {
                        TCKResourceImpl.this.log.warning("No listener set during onEventProcessingSuccessful() call. Event object ID=" + l);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.handleFailedNotification((RemoteException)privilegedActionException.getException());
        }
    }

    public void onEventProcessingFailed(final long l, final String string, final Exception exception) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    TCKResourceListener tCKResourceListener = TCKResourceImpl.this.getResourceListener();
                    if (tCKResourceListener != null) {
                        tCKResourceListener.onEventProcessingFailed(l, string, exception);
                    } else {
                        TCKResourceImpl.this.log.warning("No listener set during onEventProcessingFailed() call. Failed event object ID=" + l);
                        if (exception != null) {
                            TCKResourceImpl.this.log.warning(exception);
                        }
                        if (string != null) {
                            TCKResourceImpl.this.log.warning(string);
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.handleFailedNotification((RemoteException)privilegedActionException.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKActivity getActivity(TCKActivityID tCKActivityID) {
        HashMap hashMap = this.activityMap;
        synchronized (hashMap) {
            ActivityState activityState = (ActivityState)this.activityMap.get(tCKActivityID);
            return activityState != null ? activityState.getActivityInterface() : null;
        }
    }

    public void sendSbbMessage(Object object) throws TCKTestErrorException {
        this.sendSbbMessage(object, null);
    }

    public Object callTest(final Object object) throws TCKTestCallException, TCKTestErrorException, RemoteException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws TCKTestCallException, TCKTestErrorException, RemoteException {
                    TCKResourceListener tCKResourceListener = TCKResourceImpl.this.getResourceListener();
                    if (tCKResourceListener != null) {
                        try {
                            return tCKResourceListener.onSbbCall(object);
                        }
                        catch (RemoteException remoteException) {
                            throw remoteException;
                        }
                        catch (Exception exception) {
                            throw new TCKTestCallException(exception);
                        }
                    }
                    throw new TCKTestErrorException("No resource listener set during callTest() call");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof TCKTestCallException) {
                throw (TCKTestCallException)exception;
            }
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw (TCKTestErrorException)exception;
        }
    }

    public TCKActivityID createActivity(String string) {
        final TCKActivityID tCKActivityID = this.createAndRegisterActivity(string);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws TCKTestErrorException, RemoteException {
                    TCKResourceImpl.this.eventDelegator.handleActivityCreatedBySbb(tCKActivityID);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.onException(privilegedActionException.getException());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    TCKResourceListener tCKResourceListener = TCKResourceImpl.this.getResourceListener();
                    if (tCKResourceListener != null) {
                        tCKResourceListener.onActivityCreatedBySbb(tCKActivityID);
                    } else {
                        TCKResourceImpl.this.log.warning("No listener set during createActivity() call");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.handleFailedNotification((RemoteException)privilegedActionException.getException());
        }
        return tCKActivityID;
    }

    public void endActivity(final TCKActivityID tCKActivityID) {
        try {
            this.markActivityEnded(tCKActivityID);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws TCKTestErrorException, RemoteException {
                        TCKResourceImpl.this.eventDelegator.handleActivityEnd(tCKActivityID, true);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.onException(privilegedActionException.getException());
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws RemoteException {
                        TCKResourceListener tCKResourceListener = TCKResourceImpl.this.getResourceListener();
                        if (tCKResourceListener != null) {
                            tCKResourceListener.onActivityEndedBySbb(tCKActivityID);
                        } else {
                            TCKResourceImpl.this.log.warning("No listener set during endActivity() call");
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.handleFailedNotification((RemoteException)privilegedActionException.getException());
            }
        }
        catch (TCKTestErrorException tCKTestErrorException) {
            this.onException(tCKTestErrorException);
        }
    }

    public void sendException(Exception exception) throws TCKTestErrorException {
        this.onException(exception);
    }

    public void log(int n, String string) throws RemoteException {
        this.log.writeToLog(n, string);
    }

    public void log(int n, Throwable throwable) throws RemoteException {
        this.log.writeToLog(n, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLive(TCKActivityID tCKActivityID) throws TCKTestErrorException {
        HashMap hashMap = this.activityMap;
        synchronized (hashMap) {
            ActivityState activityState = (ActivityState)this.activityMap.get(tCKActivityID);
            return activityState != null && activityState.isLive();
        }
    }

    public void sendSbbMessage(final Object object, final TCKActivityID tCKActivityID) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    TCKSbbMessageImpl tCKSbbMessageImpl = new TCKSbbMessageImpl(object);
                    TCKResourceListener tCKResourceListener = TCKResourceImpl.this.getResourceListener();
                    if (tCKResourceListener != null) {
                        tCKResourceListener.onSbbMessage(tCKSbbMessageImpl, tCKActivityID);
                    } else {
                        TCKResourceImpl.this.log.warning("No listener set during sendSbbMessage() call");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.handleFailedNotification((RemoteException)privilegedActionException.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TCKActivityID createAndRegisterActivity(String string) {
        long l = this.nextActivityOID();
        TCKActivityIDImpl tCKActivityIDImpl = new TCKActivityIDImpl(l, string);
        TCKActivityImpl tCKActivityImpl = new TCKActivityImpl(tCKActivityIDImpl, this);
        HashMap hashMap = this.activityMap;
        synchronized (hashMap) {
            this.activityMap.put(tCKActivityIDImpl, new ActivityState(tCKActivityImpl));
        }
        return tCKActivityIDImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markActivityEnded(TCKActivityID tCKActivityID) throws TCKTestErrorException {
        HashMap hashMap = this.activityMap;
        synchronized (hashMap) {
            ActivityState activityState = (ActivityState)this.activityMap.get(tCKActivityID);
            if (activityState == null) {
                throw new TCKTestErrorException("Attempt to end an unknown activity: " + tCKActivityID);
            }
            ActivityState activityState2 = activityState;
            synchronized (activityState2) {
                if (!activityState.isLive()) {
                    throw new TCKTestErrorException("Can't end an activity which is not live: " + tCKActivityID);
                }
                activityState.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long nextEventOID() {
        Class<TCKResourceImpl> clazz = TCKResourceImpl.class;
        synchronized (TCKResourceImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return eventOIDCounter++;
        }
    }

    EventDelegator getEventDelegator() {
        return this.eventDelegator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextActivityOID() {
        Class<TCKResourceImpl> clazz = TCKResourceImpl.class;
        synchronized (TCKResourceImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return activityOIDCounter++;
        }
    }

    private void handleFailedNotification(final RemoteException remoteException) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                TCKResourceImpl.this.log.warning("Caught RemoteException while calling the resource listener:");
                TCKResourceImpl.this.log.warning(remoteException);
                return null;
            }
        });
    }

    private TCKResourceListener getResourceListener() {
        return this.testInterfaceImpl.getResourceListener();
    }
}

