/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.sbbutils.events2;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import java.rmi.RemoteException;
import java.util.HashMap;

public abstract class SbbMessageAdapter
extends BaseTCKResourceListener {
    public void onSbbLogCall(String string) {
        this.getLog().fine("Sbb wants to log: " + string);
    }

    public abstract Logable getLog();

    public Object onSbbCall(Object object) throws Exception {
        this.getLog().info("Received synchronous call from Sbb");
        HashMap hashMap = (HashMap)object;
        Integer n = (Integer)hashMap.get("Type");
        switch (n) {
            case 1: {
                String string = (String)hashMap.get("Msg");
                this.onSbbLogCall(string);
                break;
            }
            default: {
                this.onHandleRequest(n, hashMap);
            }
        }
        return new Boolean(true);
    }

    public void onSetPassed(int n, String string) {
    }

    public void onSetFailed(int n, String string) {
    }

    public void onHandleRequest(int n, HashMap hashMap) throws Exception {
    }

    public synchronized void onSbbMessage(TCKSbbMessage tCKSbbMessage, TCKActivityID tCKActivityID) throws RemoteException {
        this.getLog().info("Received message from SBB: " + tCKSbbMessage.getMessage());
        if (tCKSbbMessage.getMessage() instanceof HashMap) {
            HashMap hashMap = (HashMap)tCKSbbMessage.getMessage();
            if (!this.checkMsgClass(hashMap)) {
                this.getLog().warning("Received message load was of type java.util.HashMap but did not carry the expected MsgClass field.");
                return;
            }
            try {
                Integer n = (Integer)hashMap.get("Type");
                switch (n) {
                    case 0: {
                        Integer n2 = (Integer)hashMap.get("ID");
                        Boolean bl = (Boolean)hashMap.get("Result");
                        String string = (String)hashMap.get("Msg");
                        if (bl.booleanValue()) {
                            this.onSetPassed(n2, string);
                            break;
                        }
                        this.onSetFailed(n2, string);
                        break;
                    }
                    default: {
                        try {
                            this.onHandleRequest(n, hashMap);
                        }
                        catch (Exception exception) {
                            this.getLog().fine("Exception occured while trying handling SbbMessage: " + exception.getMessage());
                        }
                        break;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                this.getLog().warning("NullPointerException occured while trying to read fields of Sbb message. The msg contents were:");
                for (Object k : hashMap.keySet()) {
                    Object v = hashMap.get(k);
                    this.getLog().warning("Key: " + k + " Value:" + v);
                }
                this.getLog().warning("Thrown exception: ");
                this.getLog().warning(nullPointerException);
                return;
            }
        } else {
            this.getLog().warning("Received message load was not a java.util.HashMap as expected, found " + tCKSbbMessage.getMessage().getClass().getName() + " instead.");
        }
    }

    public void onSetException(Exception exception) {
    }

    public void onException(Exception exception) throws RemoteException {
        this.getLog().warning("Received exception from SBB.");
        this.getLog().warning(exception);
        this.onSetException(exception);
    }

    private boolean checkMsgClass(HashMap hashMap) {
        Integer n = (Integer)hashMap.get("MsgClass");
        return n != null && n == 2;
    }
}

