/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.activities.activitycontext;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.management.DeployableUnitID;

public class ExplicitAttachTest
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        String activityName = "ExplicitAttachTest";
        TCKActivityID activityID = resource.createActivity(activityName);
        this.utils.getLog().fine("Firing TCKResourceExentX at SBB.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        this.utils.getLog().fine("Waiting for test pass indicator from SBB.");
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "No response from the SBB", 538);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        DeployableUnitID duID = this.utils.install(duPath);
        this.utils.activateServices(duID, true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            ExplicitAttachTest.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                ExplicitAttachTest.this.result.setPassed();
            } else {
                ExplicitAttachTest.this.result.setFailed(538, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            ExplicitAttachTest.this.utils.getLog().warning("Received exception from SBB");
            ExplicitAttachTest.this.utils.getLog().warning(e);
            ExplicitAttachTest.this.result.setError(e);
        }
    }
}

