/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.concurrency;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import javax.slee.Address;
import javax.slee.AddressPlan;

public class SbbActivityConcurrencyTest
extends AbstractSleeTCKTest {
    private static final String WAIT_PERIOD_MS_PARAM = "waitPeriodMs";
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    private int waitPeriodMs;
    private Object sbbCallLock = new Object();
    private int addressSuffix = 1;
    private String testCase;
    private TCKActivityID activityID;
    private String event1Type;
    private int event1ACKCode;
    private String event2Type;
    private int event2ACKCode;
    private int event2RollbackCode;
    private int expectedEvent2ACKs;
    private FutureResult testCaseResult;
    private volatile boolean isEvent1Received;
    private volatile int event2HandlerACKCount;
    private volatile int event2RolledBackCount;
    private volatile boolean isEvent1ProcessingFinished;
    private volatile boolean isEvent2ProcessingFinished;
    private volatile long event1ObjectID;
    private volatile long event2ObjectID;
    private boolean isBlocking;
    private boolean stopBlocking;

    public TCKTestResult run() throws Exception {
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        String testCase = "Fire events on an activity to multiple instances of the same Sbb component";
        this.getLog().info("Creating activity A");
        TCKActivityID activityA = resource.createActivity("SbbActivityConcurrencyTest-ActvityA");
        TCKTestResult testCaseAResult = this.testConcurrency(activityA, "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", 1, "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", 2, 5, 2, testCase);
        if (!testCaseAResult.isPassed()) {
            return testCaseAResult;
        }
        testCase = "Fire events on an activity to different Sbb components";
        this.getLog().info("Creating activity B");
        TCKActivityID activityB = resource.createActivity("SbbActivityConcurrencyTest-ActvityB");
        return this.testConcurrency(activityB, "com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", 3, "com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2", 4, 6, 1, testCase);
    }

    public void setUp() throws Exception {
        this.waitPeriodMs = Integer.parseInt(this.utils().getTestParams().getProperty(WAIT_PERIOD_MS_PARAM));
        this.setResourceListener(new ResourceListenerImpl());
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.setupService(SERVICE2_DU_PATH_PARAM, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCKTestResult testConcurrency(TCKActivityID activityID, String event1Type, int event1ACKCode, String event2Type, int event2ACKCode, int event2RollbackCode, int expectedEvent2ACKs, String testCase) throws TCKTestErrorException, RemoteException {
        this.getLog().info("Test case: " + testCase);
        this.stopBlocking = false;
        this.isBlocking = false;
        this.isEvent2ProcessingFinished = false;
        this.isEvent1ProcessingFinished = false;
        this.isEvent1Received = false;
        this.event2RolledBackCount = 0;
        this.event2HandlerACKCount = 0;
        this.event2ObjectID = 0L;
        this.event1ObjectID = 0L;
        this.testCaseResult = new FutureResult(this.getLog());
        this.activityID = activityID;
        this.event1Type = event1Type;
        this.event1ACKCode = event1ACKCode;
        this.event2Type = event2Type;
        this.event2ACKCode = event2ACKCode;
        this.event2RollbackCode = event2RollbackCode;
        this.expectedEvent2ACKs = expectedEvent2ACKs;
        this.testCase = testCase;
        this.getLog().info("Firing an " + event1Type + " event on activity: " + activityID + ", on a new address");
        Object object = this.sbbCallLock;
        synchronized (object) {
            this.event1ObjectID = this.utils().getResourceInterface().fireEvent(event1Type, null, activityID, this.nextAddress());
        }
        long timeout = this.utils().getTestTimeout() + this.waitPeriodMs;
        this.getLog().fine("Total timeout is " + timeout + " ms");
        try {
            TCKTestResult tCKTestResult = this.testCaseResult.waitForResult(timeout);
            return tCKTestResult;
        }
        catch (Future.TimeoutException ex) {
            String testState = "isEvent1Received=" + this.isEvent1Received + ",isEvent1ProcessingFinished=" + this.isEvent1ProcessingFinished + ",event2HandlerACKCount count=" + this.event2HandlerACKCount + ",event2RolledBackCount count=" + this.event2RolledBackCount + ",isEvent2ProcessingFinished=" + this.isEvent2ProcessingFinished + ",event1ObjectID=" + this.event1ObjectID + ",event2ObjectID=" + this.event2ObjectID + ",isBlocking=" + this.isBlocking;
            TCKTestResult tCKTestResult = TCKTestResult.error("Timed out while waiting for event handler invocations. Test case:" + testCase + ". Test state: " + testState, ex);
            return tCKTestResult;
        }
        finally {
            this.waitToUnblock();
            this.waitForEventProcessing();
        }
    }

    private synchronized Address nextAddress() {
        return new Address(AddressPlan.IP, "1.0.0." + this.addressSuffix++);
    }

    private String formatCallCode(int callCode) {
        switch (callCode) {
            case 1: {
                return "SBB1 RECEIVED X1";
            }
            case 2: {
                return "SBB1 RECEIVED X2";
            }
            case 3: {
                return "SBB1 RECEIVED Y1";
            }
            case 4: {
                return "SBB2 RECEIVED Y2";
            }
        }
        return "(Invalid call code:" + callCode + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitToUnblock() {
        Object object = this.sbbCallLock;
        synchronized (object) {
            if (this.isBlocking) {
                this.stopBlocking = true;
                this.sbbCallLock.notifyAll();
                while (this.isBlocking) {
                    try {
                        this.getLog().finest("Waiting for sbb call to unblock...");
                        this.sbbCallLock.wait();
                        this.getLog().finest("Unblocked");
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEventProcessing() {
        Object object = this.sbbCallLock;
        synchronized (object) {
            if (!this.isEvent1ProcessingFinished || !this.isEvent2ProcessingFinished) {
                long now = System.currentTimeMillis();
                long timeoutAt = now + (long)this.utils().getTestTimeout();
                this.getLog().info("Will wait for " + this.utils().getTestTimeout() + " ms, or until event processing finishes for both events");
                while (!(now >= timeoutAt || this.isEvent1ProcessingFinished && this.isEvent2ProcessingFinished)) {
                    try {
                        this.sbbCallLock.wait(timeoutAt - now);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    now = System.currentTimeMillis();
                }
            }
        }
    }

    private class ResourceListenerImpl
    extends BaseTCKResourceListener {
        private ResourceListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object onSbbCall(Object argument) throws Exception {
            try {
                Object object = SbbActivityConcurrencyTest.this.sbbCallLock;
                synchronized (object) {
                    int code = (Integer)argument;
                    SbbActivityConcurrencyTest.this.getLog().info("Received call from sbb. Code=" + SbbActivityConcurrencyTest.this.formatCallCode(code));
                    if (code == SbbActivityConcurrencyTest.this.event1ACKCode) {
                        SbbActivityConcurrencyTest.this.isEvent1Received = true;
                        SbbActivityConcurrencyTest.this.getLog().info("Firing a " + SbbActivityConcurrencyTest.this.event2Type + " event on activity " + SbbActivityConcurrencyTest.this.activityID);
                        SbbActivityConcurrencyTest.this.event2ObjectID = SbbActivityConcurrencyTest.this.utils().getResourceInterface().fireEvent(SbbActivityConcurrencyTest.this.event2Type, null, SbbActivityConcurrencyTest.this.activityID, SbbActivityConcurrencyTest.this.nextAddress());
                        SbbActivityConcurrencyTest.this.isBlocking = true;
                        try {
                            long now = System.currentTimeMillis();
                            long timeoutAt = now + (long)SbbActivityConcurrencyTest.this.waitPeriodMs;
                            SbbActivityConcurrencyTest.this.getLog().info("Will wait for " + SbbActivityConcurrencyTest.this.waitPeriodMs + " ms, or until a result is set");
                            while (now < timeoutAt && !SbbActivityConcurrencyTest.this.testCaseResult.isSet() && !SbbActivityConcurrencyTest.this.stopBlocking) {
                                SbbActivityConcurrencyTest.this.sbbCallLock.wait(timeoutAt - now);
                                now = System.currentTimeMillis();
                            }
                            SbbActivityConcurrencyTest.this.getLog().info("Stopped blocking.");
                        }
                        finally {
                            SbbActivityConcurrencyTest.this.isBlocking = false;
                            SbbActivityConcurrencyTest.this.sbbCallLock.notifyAll();
                        }
                    } else if (code == SbbActivityConcurrencyTest.this.event2ACKCode) {
                        if (SbbActivityConcurrencyTest.this.isBlocking) {
                            throw new TCKTestFailureException(771, "Serial method invocation was not maintained on a single activity. Test case:" + SbbActivityConcurrencyTest.this.testCase);
                        }
                        SbbActivityConcurrencyTest.this.event2HandlerACKCount++;
                    } else if (code == SbbActivityConcurrencyTest.this.event2RollbackCode) {
                        SbbActivityConcurrencyTest.this.event2RolledBackCount++;
                    } else {
                        throw new TCKTestErrorException("Unexpected code passed to onSbbCall() during " + SbbActivityConcurrencyTest.this.testCase + " test case: " + SbbActivityConcurrencyTest.this.formatCallCode(code));
                    }
                    this.checkIsSatisfied();
                }
            }
            catch (Exception exception) {
                this.onException(exception);
            }
            return null;
        }

        public void onEventProcessingSuccessful(long eventObjectID) throws RemoteException {
            this.onEventProcessingCompleted(eventObjectID, true, null, null);
        }

        public void onEventProcessingFailed(long eventObjectID, String message, Exception exception) {
            this.onEventProcessingCompleted(eventObjectID, false, message, exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onEventProcessingCompleted(long eventObjectID, boolean wasSuccess, String message, Exception exception) {
            Object object = SbbActivityConcurrencyTest.this.sbbCallLock;
            synchronized (object) {
                if (eventObjectID == SbbActivityConcurrencyTest.this.event2ObjectID) {
                    if (SbbActivityConcurrencyTest.this.event2HandlerACKCount < SbbActivityConcurrencyTest.this.expectedEvent2ACKs) {
                        String methodName = wasSuccess ? "onEventProcessingSuccessful()" : "onEventProcessingFailed()";
                        SbbActivityConcurrencyTest.this.getLog().warning("Received " + methodName + " call for " + SbbActivityConcurrencyTest.this.event2Type + " event before the expected number of " + "ACKs were received from the " + SbbActivityConcurrencyTest.this.event2Type + " event handler. " + "This is allowed by the test, as the SLEE may choose to timeout the " + SbbActivityConcurrencyTest.this.event2Type + " event while waiting for the blocking callback to return, or rollback event delivery attempts. " + "Number of sbbRolledBack() ACKs received for the event: " + SbbActivityConcurrencyTest.this.event2RolledBackCount);
                        if (!wasSuccess) {
                            SbbActivityConcurrencyTest.this.getLog().warning("Failure message=" + message + ". Failure exception follows:");
                            SbbActivityConcurrencyTest.this.getLog().warning(exception);
                        }
                    }
                    SbbActivityConcurrencyTest.this.isEvent2ProcessingFinished = true;
                    this.checkIsSatisfied();
                } else if (eventObjectID == SbbActivityConcurrencyTest.this.event1ObjectID) {
                    SbbActivityConcurrencyTest.this.isEvent1ProcessingFinished = true;
                    if (wasSuccess) {
                        SbbActivityConcurrencyTest.this.getLog().fine("Received onEventProcessingSuccessful() callback for " + SbbActivityConcurrencyTest.this.event1Type + " event. eventObjectID=" + eventObjectID);
                    } else {
                        this.onException(new TCKTestErrorException("Unexpected call to onEventProcessingFailed() received for " + SbbActivityConcurrencyTest.this.event1Type + " event. eventObjectID=" + eventObjectID + ". Failure message=" + message, exception));
                    }
                } else if (wasSuccess) {
                    SbbActivityConcurrencyTest.this.getLog().warning("Received unexpected onEventProcessingSuccessful() callback for an event which doesn't appear to be either of the events fired in this test case. eventObjectID=" + eventObjectID);
                } else {
                    this.onException(new TCKTestErrorException("Unexpected call to onEventProcessingFailed() received for an event which doesn't appear to be either of the events fired in this test case. eventObjectID=" + eventObjectID + ". Failure message=" + message, exception));
                }
            }
        }

        public void onException(Exception exception) {
            if (exception instanceof TCKTestFailureException) {
                SbbActivityConcurrencyTest.this.testCaseResult.setFailed((TCKTestFailureException)exception);
            } else {
                SbbActivityConcurrencyTest.this.testCaseResult.setError(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkIsSatisfied() {
            Object object = SbbActivityConcurrencyTest.this.sbbCallLock;
            synchronized (object) {
                if (!(SbbActivityConcurrencyTest.this.event2HandlerACKCount < SbbActivityConcurrencyTest.this.expectedEvent2ACKs && !SbbActivityConcurrencyTest.this.isEvent2ProcessingFinished || SbbActivityConcurrencyTest.this.isBlocking || SbbActivityConcurrencyTest.this.testCaseResult.isSet())) {
                    SbbActivityConcurrencyTest.this.getLog().info("All callbacks received serially");
                    SbbActivityConcurrencyTest.this.testCaseResult.setPassed();
                }
            }
        }
    }
}

