/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.concurrency;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.slee.Address;
import javax.slee.AddressPlan;

public class SbbObjectConcurrencyTest
extends AbstractSleeTCKTest {
    private static final String WAIT_PERIOD_MS_PARAM = "waitPeriodMs";
    private int waitPeriodMs;
    private TCKActivityID activityB;
    private Address address;
    private Map activeCalls;
    private int nextSbbOID = 1;
    private FutureResult result;
    private Object stateLock = new Object();
    private volatile boolean isX1HandlerCalled;
    private volatile boolean isSbbExceptionThrownCalled;
    private volatile boolean isX1RolledBack;
    private long y1EventObjectID;
    private long y2EventObjectID;
    private long y3EventObjectID;
    private volatile boolean isY1HandlerCalled;
    private volatile boolean isY2HandlerCalled;
    private volatile boolean isY3HandlerCalled;
    private volatile boolean isY1RolledBack;
    private volatile boolean isY2RolledBack;
    private volatile boolean isY3RolledBack;
    private volatile boolean isY1ProcessingFinished;
    private volatile boolean isY2ProcessingFinished;
    private volatile boolean isY3ProcessingFinished;

    public TCKTestResult run() throws Exception {
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        this.getLog().info("Creating activities A and B");
        TCKActivityID activityA = resource.createActivity("SbbObjectConcurrencyTest-ActvityA");
        this.activityB = resource.createActivity("SbbObjectConcurrencyTest-ActvityB");
        this.getLog().info("firing an X1 event on activity A");
        this.address = new Address(AddressPlan.IP, "1.0.0.1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activityA, this.address);
        long timeout = this.utils().getTestTimeout() + this.waitPeriodMs * 3;
        this.getLog().info("Total timeout is " + timeout + " ms");
        try {
            return this.result.waitForResult(timeout);
        }
        catch (Future.TimeoutException timeoutException) {
            return this.diagnoseTimeout(timeoutException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCKTestResult diagnoseTimeout(Future.TimeoutException timeoutException) {
        Object object = this.stateLock;
        synchronized (object) {
            boolean isY3EventFired;
            String diagnosis = null;
            boolean isY1EventFired = this.y1EventObjectID == -1L;
            boolean isY2EventFired = this.y2EventObjectID == -1L;
            boolean bl = isY3EventFired = this.y3EventObjectID == -1L;
            if (this.isX1HandlerCalled && this.isSbbExceptionThrownCalled && this.isX1RolledBack) {
                if (!(this.isY1HandlerCalled || this.isY1RolledBack || this.isY1ProcessingFinished)) {
                    diagnosis = isY1EventFired ? "Test error: test didn't appear to successfully fire Y1 event" : "Didn't receive ACK from event handler or rollback or indication of event processing completion for Y1 event";
                } else if (!(this.isY2HandlerCalled || this.isY2RolledBack || this.isY2ProcessingFinished)) {
                    diagnosis = isY2EventFired ? "Test error: test didn't appear to successfully fire Y2 event" : "Didn't receive ACK from event handler or rollback or indication of event processing completion for Y2 event";
                } else if (!(this.isY3HandlerCalled || this.isY3RolledBack || this.isY3ProcessingFinished)) {
                    diagnosis = isY3EventFired ? "Test error: test didn't appear to successfully fire Y3 event" : "Didn't receive ACK from event handler or rollback or indication of event processing completion for Y3 event";
                }
            } else if (!this.isX1RolledBack) {
                diagnosis = "sbbRolledBack() wasn't called for the X1 event";
            } else if (!this.isSbbExceptionThrownCalled) {
                diagnosis = "sbbExceptionThrown() wasn't called";
            } else if (!this.isX1HandlerCalled) {
                diagnosis = "X1 event handler wasn't called";
            }
            String testState = "isX1HandlerCalled=" + this.isX1HandlerCalled + ",isSbbExceptionThrownCalled=" + this.isSbbExceptionThrownCalled + ",isX1RolledBack=" + this.isX1RolledBack + ",isY1EventFired=" + isY1EventFired + ",isY1HandlerCalled=" + this.isY1HandlerCalled + ",isY1ProcessingFinished=" + this.isY1ProcessingFinished + ",isY2EventFired=" + isY2EventFired + ",isY2HandlerCalled=" + this.isY2HandlerCalled + ",isY2ProcessingFinished=" + this.isY2ProcessingFinished + ",isY3EventFired=" + isY3EventFired + ",isY3HandlerCalled=" + this.isY3HandlerCalled + ",isY3ProcessingFinished=" + this.isY3ProcessingFinished;
            return TCKTestResult.error("Timed out while waiting for event handler invocations and sbb callbacks. Diagnosis:" + diagnosis + ". Test state:" + testState, timeoutException);
        }
    }

    public void setUp() throws Exception {
        this.waitPeriodMs = Integer.parseInt(this.utils().getTestParams().getProperty(WAIT_PERIOD_MS_PARAM));
        this.activeCalls = new HashMap();
        this.y3EventObjectID = 0L;
        this.y2EventObjectID = 0L;
        this.y1EventObjectID = 0L;
        this.isX1RolledBack = false;
        this.isSbbExceptionThrownCalled = false;
        this.isX1HandlerCalled = false;
        this.isY3HandlerCalled = false;
        this.isY2HandlerCalled = false;
        this.isY1HandlerCalled = false;
        this.isY3RolledBack = false;
        this.isY2RolledBack = false;
        this.isY1RolledBack = false;
        this.isY3ProcessingFinished = false;
        this.isY2ProcessingFinished = false;
        this.isY1ProcessingFinished = false;
        this.result = new FutureResult(this.getLog());
        this.setResourceListener(new ResourceListenerImpl());
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.activeCalls.clear();
        this.activityB = null;
    }

    private synchronized int allocateSbbOID() {
        return this.nextSbbOID++;
    }

    private String formatCallCode(Integer callCode) {
        switch (callCode) {
            case 1: {
                return "REQUEST_SBB_OID";
            }
            case 2: {
                return "RECEIVED_X1";
            }
            case 3: {
                return "RECEIVED_Y1";
            }
            case 4: {
                return "RECEIVED_Y2";
            }
            case 5: {
                return "RECEIVED_Y3";
            }
            case 6: {
                return "SBB_ROLLED_BACK_X1";
            }
            case 7: {
                return "SBB_ROLLED_BACK_Y1";
            }
            case 8: {
                return "SBB_ROLLED_BACK_Y2";
            }
            case 9: {
                return "SBB_ROLLED_BACK_Y3";
            }
            case 10: {
                return "SBB_EXCEPTION_THROWN";
            }
        }
        return "(Invalid call code:" + callCode + ")";
    }

    private class ResourceListenerImpl
    extends BaseTCKResourceListener {
        private ResourceListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object onSbbCall(Object argument) throws Exception {
            try {
                int[] codeAndSbbOID = (int[])argument;
                Integer code = new Integer(codeAndSbbOID[0]);
                Integer sbbObjectID = new Integer(codeAndSbbOID[1]);
                SbbObjectConcurrencyTest.this.getLog().info("Received call from sbb object " + sbbObjectID + ". Code=" + SbbObjectConcurrencyTest.this.formatCallCode(code));
                if (code == 1) {
                    return new Integer(SbbObjectConcurrencyTest.this.allocateSbbOID());
                }
                Object object = SbbObjectConcurrencyTest.this.stateLock;
                synchronized (object) {
                    boolean shouldBlock = this.handleSbbInvocationACK(code);
                    Integer currentForSbbObject = (Integer)SbbObjectConcurrencyTest.this.activeCalls.get(sbbObjectID);
                    if (currentForSbbObject != null) {
                        throw new TCKTestFailureException(770, "Serial method invocation was not maintained on a single sbb object.sbbObjectID=" + sbbObjectID + ", active method type=" + SbbObjectConcurrencyTest.this.formatCallCode(currentForSbbObject) + ". second method type=" + SbbObjectConcurrencyTest.this.formatCallCode(code));
                    }
                    if (shouldBlock) {
                        SbbObjectConcurrencyTest.this.getLog().info("Registering the current method invocation for sbb object " + sbbObjectID);
                        SbbObjectConcurrencyTest.this.activeCalls.put(sbbObjectID, code);
                        long now = System.currentTimeMillis();
                        long timeoutAt = now + (long)SbbObjectConcurrencyTest.this.waitPeriodMs;
                        SbbObjectConcurrencyTest.this.getLog().info("Will wait for " + SbbObjectConcurrencyTest.this.waitPeriodMs + " ms, or until a result is set");
                        while (now < timeoutAt && !SbbObjectConcurrencyTest.this.result.isSet()) {
                            try {
                                SbbObjectConcurrencyTest.this.stateLock.wait(timeoutAt - now);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            now = System.currentTimeMillis();
                        }
                        SbbObjectConcurrencyTest.this.getLog().info("Timeout reached, or result set. Deregistering method invocation for sbb object " + sbbObjectID);
                        SbbObjectConcurrencyTest.this.activeCalls.remove(sbbObjectID);
                    }
                    this.checkIsSatisfied();
                }
            }
            catch (Exception exception) {
                this.onException(exception);
            }
            return null;
        }

        public void onEventProcessingSuccessful(long eventObjectID) throws RemoteException {
            this.onEventProcessingCompleted(eventObjectID, true, null, null);
        }

        public void onEventProcessingFailed(long eventObjectID, String message, Exception exception) {
            this.onEventProcessingCompleted(eventObjectID, false, message, exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(Exception exception) {
            if (exception instanceof TCKTestFailureException) {
                SbbObjectConcurrencyTest.this.result.setFailed((TCKTestFailureException)exception);
            } else {
                SbbObjectConcurrencyTest.this.result.setError(exception);
            }
            Object object = SbbObjectConcurrencyTest.this.stateLock;
            synchronized (object) {
                SbbObjectConcurrencyTest.this.stateLock.notifyAll();
            }
        }

        private boolean handleSbbInvocationACK(int callCode) throws Exception {
            boolean shouldBlock = false;
            switch (callCode) {
                case 2: {
                    SbbObjectConcurrencyTest.this.isX1HandlerCalled = true;
                    SbbObjectConcurrencyTest.this.getLog().info("Firing a Y1 event on activity B");
                    SbbObjectConcurrencyTest.this.y1EventObjectID = SbbObjectConcurrencyTest.this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", null, SbbObjectConcurrencyTest.this.activityB, SbbObjectConcurrencyTest.this.address);
                    shouldBlock = true;
                    break;
                }
                case 10: {
                    SbbObjectConcurrencyTest.this.isSbbExceptionThrownCalled = true;
                    SbbObjectConcurrencyTest.this.getLog().info("Firing a Y2 event on activity B");
                    SbbObjectConcurrencyTest.this.y2EventObjectID = SbbObjectConcurrencyTest.this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2", null, SbbObjectConcurrencyTest.this.activityB, SbbObjectConcurrencyTest.this.address);
                    shouldBlock = true;
                    break;
                }
                case 6: {
                    SbbObjectConcurrencyTest.this.isX1RolledBack = true;
                    SbbObjectConcurrencyTest.this.getLog().info("Firing a Y3 event on activity B");
                    SbbObjectConcurrencyTest.this.y3EventObjectID = SbbObjectConcurrencyTest.this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y3", null, SbbObjectConcurrencyTest.this.activityB, SbbObjectConcurrencyTest.this.address);
                    shouldBlock = true;
                    break;
                }
                case 3: {
                    SbbObjectConcurrencyTest.this.isY1HandlerCalled = true;
                    break;
                }
                case 4: {
                    SbbObjectConcurrencyTest.this.isY2HandlerCalled = true;
                    break;
                }
                case 5: {
                    SbbObjectConcurrencyTest.this.isY3HandlerCalled = true;
                    break;
                }
                case 7: {
                    SbbObjectConcurrencyTest.this.isY1RolledBack = true;
                    break;
                }
                case 8: {
                    SbbObjectConcurrencyTest.this.isY2RolledBack = true;
                    break;
                }
                case 9: {
                    SbbObjectConcurrencyTest.this.isY3RolledBack = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized code passed to onSbbCall(): " + callCode);
                }
            }
            return shouldBlock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onEventProcessingCompleted(long eventObjectID, boolean wasSuccess, String message, Exception exception) {
            Object object = SbbObjectConcurrencyTest.this.stateLock;
            synchronized (object) {
                boolean isY3Event;
                boolean isY1Event = eventObjectID == SbbObjectConcurrencyTest.this.y1EventObjectID;
                boolean isY2Event = eventObjectID == SbbObjectConcurrencyTest.this.y2EventObjectID;
                boolean bl = isY3Event = eventObjectID == SbbObjectConcurrencyTest.this.y3EventObjectID;
                if (isY1Event || isY2Event || isY3Event) {
                    boolean isACKOrRollbackReceived;
                    boolean bl2 = isY1Event ? SbbObjectConcurrencyTest.this.isY1HandlerCalled || SbbObjectConcurrencyTest.this.isY1RolledBack : (isY2Event ? SbbObjectConcurrencyTest.this.isY2HandlerCalled || SbbObjectConcurrencyTest.this.isY2RolledBack : (isACKOrRollbackReceived = SbbObjectConcurrencyTest.this.isY3HandlerCalled || SbbObjectConcurrencyTest.this.isY3RolledBack));
                    if (!isACKOrRollbackReceived) {
                        String eventName = isY1Event ? "Y1" : (isY2Event ? "Y2" : "Y3");
                        String methodName = wasSuccess ? "onEventProcessingSuccessful()" : "onEventProcessingFailed()";
                        SbbObjectConcurrencyTest.this.getLog().warning("Received " + methodName + " call for a " + eventName + " event before an ACK was received " + "from the " + eventName + " event handler, or from an sbbRolledBack() call for the event. " + "This is allowed by the test, as the SLEE may choose to timeout the " + eventName + " event while waiting for the blocking callback to return.");
                        if (!wasSuccess) {
                            SbbObjectConcurrencyTest.this.getLog().warning("Failure message=" + message + ". Failure exception follows:");
                            SbbObjectConcurrencyTest.this.getLog().warning(exception);
                        }
                    }
                    if (isY1Event) {
                        SbbObjectConcurrencyTest.this.isY1ProcessingFinished = true;
                    } else if (isY2Event) {
                        SbbObjectConcurrencyTest.this.isY2ProcessingFinished = true;
                    } else if (isY3Event) {
                        SbbObjectConcurrencyTest.this.isY3ProcessingFinished = true;
                    }
                    this.checkIsSatisfied();
                } else if (wasSuccess) {
                    SbbObjectConcurrencyTest.this.getLog().fine("Received onEventProcessingSuccessful() callback for X1 event");
                } else {
                    this.onException(new TCKTestErrorException("Unexpected call to onEventProcessingFailed() received  for the X1 event. eventObjectID=" + eventObjectID + ". Failure message=" + message, exception));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkIsSatisfied() {
            Object object = SbbObjectConcurrencyTest.this.stateLock;
            synchronized (object) {
                if (SbbObjectConcurrencyTest.this.isX1HandlerCalled && SbbObjectConcurrencyTest.this.isSbbExceptionThrownCalled && SbbObjectConcurrencyTest.this.isX1RolledBack && (SbbObjectConcurrencyTest.this.isY1HandlerCalled || SbbObjectConcurrencyTest.this.isY1RolledBack || SbbObjectConcurrencyTest.this.isY1ProcessingFinished) && (SbbObjectConcurrencyTest.this.isY2HandlerCalled || SbbObjectConcurrencyTest.this.isY2RolledBack || SbbObjectConcurrencyTest.this.isY2ProcessingFinished) && (SbbObjectConcurrencyTest.this.isY3HandlerCalled || SbbObjectConcurrencyTest.this.isY3RolledBack || SbbObjectConcurrencyTest.this.isY3ProcessingFinished) && SbbObjectConcurrencyTest.this.activeCalls.isEmpty() && !SbbObjectConcurrencyTest.this.result.isSet()) {
                    SbbObjectConcurrencyTest.this.getLog().info("All expected callbacks received serially");
                    SbbObjectConcurrencyTest.this.result.setPassed();
                    SbbObjectConcurrencyTest.this.stateLock.notifyAll();
                }
            }
        }
    }
}

