/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.convergencename;

import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.AbstractConvergenceNameTest;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.InitialEventSelectorParameters;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.AddressProfileProxyImpl;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.AddressPlan;

public class AddressAndAddressProfileConvergenceNameTest
extends AbstractConvergenceNameTest {
    private static final String PROFILE_1 = "PROFILE_1";
    private static final String PROFILE_2 = "PROFILE_2";
    private static final String ADDRESS_PROFILE_TABLE = "tck.AddressAndProfileTestProfile";
    private static final Address ADDRESS_1 = new Address(AddressPlan.IP, "1.0.0.1");
    private static final Address ADDRESS_2 = new Address(AddressPlan.IP, "1.0.0.2");
    private static final Address ADDRESS_3 = new Address(AddressPlan.IP, "1.0.0.3");
    private static final Address ADDRESS_4 = new Address(AddressPlan.IP, "1.0.0.4");
    private static final Address[] ADDRESS_SET_A = new Address[]{ADDRESS_1, ADDRESS_2};
    private static final Address[] ADDRESS_SET_B = new Address[]{ADDRESS_3, ADDRESS_4};
    private ProfileUtils profileUtils;
    private final boolean[][] testCaseConfig = new boolean[][]{{false, false}, {false, true}, {true, false}, {true, true}};
    private int currentActivityIDSuffix = 0;
    private int currentEventID = 0;
    private ProfileProvisioningMBeanProxy profileProxy;

    private void runTestCase(int testCaseNumber) throws Exception {
        String controlSBBID;
        InitialEventSelectorParameters iesParams = new InitialEventSelectorParameters(true, this.testCaseConfig[testCaseNumber][0], this.testCaseConfig[testCaseNumber][1], false, false, null, false, false, false, null);
        this.getLog().info("Test Case: " + testCaseNumber + ", Address selected=" + this.testCaseConfig[testCaseNumber][0] + ", AddressProfile selected=" + this.testCaseConfig[testCaseNumber][1]);
        this.setAddressProfile(PROFILE_2, new Address[0]);
        this.setAddressProfile(PROFILE_1, ADDRESS_SET_A);
        this.setAddressProfile(PROFILE_2, ADDRESS_SET_B);
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("Activity" + this.currentActivityIDSuffix++);
        String expectedRespondingSBBID = controlSBBID = String.valueOf(this.currentEventID++);
        this.sendEventAndWait("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", controlSBBID, activityID, ADDRESS_1, expectedRespondingSBBID, iesParams);
        this.fireTestEvent(iesParams, activityID, ADDRESS_2, controlSBBID, this.testCaseConfig[testCaseNumber][0]);
        this.setAddressProfile(PROFILE_2, new Address[0]);
        this.setAddressProfile(PROFILE_1, ADDRESS_SET_B);
        this.setAddressProfile(PROFILE_2, ADDRESS_SET_A);
        this.fireTestEvent(iesParams, activityID, ADDRESS_1, controlSBBID, this.testCaseConfig[testCaseNumber][1]);
    }

    private void fireTestEvent(InitialEventSelectorParameters iesParams, TCKActivityID activityID, Address address, String initialSBBEventID, boolean expectNewSBB) throws Exception {
        String newEventID = String.valueOf(this.currentEventID++);
        this.sendEventAndWait("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", newEventID, activityID, address, expectNewSBB ? newEventID : initialSBBEventID, iesParams);
    }

    public TCKTestResult run() throws Exception {
        for (int i = 0; i < this.testCaseConfig.length; ++i) {
            this.runTestCase(i);
        }
        return TCKTestResult.passed();
    }

    private void setAddressProfile(String profileName, Address[] addresses) throws Exception {
        ObjectName objectName = this.profileProxy.getProfile(ADDRESS_PROFILE_TABLE, profileName);
        this.setAddressProfile(objectName, addresses);
    }

    private void setAddressProfile(ObjectName objectName, Address[] addresses) throws Exception {
        AddressProfileProxyImpl addressProfileProxy = new AddressProfileProxyImpl(objectName, this.utils().getMBeanFacade());
        addressProfileProxy.editProfile();
        addressProfileProxy.setAddresses(addresses);
        addressProfileProxy.commitProfile();
    }

    public void setUp() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileUtils.createStandardAddressProfileTable(ADDRESS_PROFILE_TABLE);
        this.profileProxy = this.profileUtils.getProfileProvisioningProxy();
        ObjectName profile = this.profileProxy.createProfile(ADDRESS_PROFILE_TABLE, PROFILE_1);
        ProfileMBeanProxy profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        profProxy.commitProfile();
        profile = this.profileProxy.createProfile(ADDRESS_PROFILE_TABLE, PROFILE_2);
        profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        profProxy.commitProfile();
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.profileUtils != null) {
            this.profileProxy.removeProfile(ADDRESS_PROFILE_TABLE, PROFILE_1);
            this.profileProxy.removeProfile(ADDRESS_PROFILE_TABLE, PROFILE_2);
            this.profileUtils.removeProfileTable(ADDRESS_PROFILE_TABLE);
        }
    }
}

