/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.convergencename;

import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.AbstractConvergenceNameTest;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.InitialEventSelectorParameters;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.impl.AddressProfileProxyImpl;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.AddressPlan;

public class AddressProfileConvergenceNameTest
extends AbstractConvergenceNameTest {
    private static final String PROFILE_1 = "PROFILE_1";
    private static final String PROFILE_2 = "PROFILE_2";
    private static final String PROFILE_3 = "PROFILE_3";
    private static final String ADDRESS_PROFILE_TABLE = "tck.AddressAndProfileTestProfile";
    private static final Address ADDRESS_1 = new Address(AddressPlan.IP, "1.0.0.1");
    private static final Address ADDRESS_2 = new Address(AddressPlan.IP, "1.0.0.2");
    private static final Address ADDRESS_3 = new Address(AddressPlan.IP, "1.0.0.3");
    private static final Address ADDRESS_4 = new Address(AddressPlan.IP, "1.0.0.4");
    private ProfileUtils profileUtils;
    private int currentActivityIDSuffix = 0;

    public TCKTestResult run() throws Exception {
        InitialEventSelectorParameters iesParams = new InitialEventSelectorParameters(false, false, true, false, false, "custom_name", false, false, false, null);
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        String eventType = "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1";
        TCKActivityID activityID = resource.createActivity("Activity" + this.currentActivityIDSuffix++);
        this.sendEventAndWait(eventType, "1", activityID, ADDRESS_1, "1", iesParams);
        this.sendEventAndWait(eventType, "2", activityID, ADDRESS_2, "2", iesParams);
        this.sendEventAndWait(eventType, "3", activityID, ADDRESS_3, "1", iesParams);
        this.sendEventAndWait(eventType, "4", activityID, ADDRESS_4, "4", iesParams);
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileUtils.createStandardAddressProfileTable(ADDRESS_PROFILE_TABLE);
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_1, new Address[]{ADDRESS_1, ADDRESS_3});
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_2, new Address[]{ADDRESS_2});
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_3, new Address[]{ADDRESS_4});
        super.setUp();
    }

    private void setupAddressProfile(String tableName, String profileName, Address[] addresses) throws Exception {
        ObjectName objectName = this.profileUtils.getProfileProvisioningProxy().createProfile(tableName, profileName);
        AddressProfileProxyImpl addressProfileProxy = new AddressProfileProxyImpl(objectName, this.utils().getMBeanFacade());
        addressProfileProxy.editProfile();
        addressProfileProxy.setAddresses(addresses);
        addressProfileProxy.commitProfile();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.profileUtils != null) {
            this.profileUtils.getProfileProvisioningProxy().removeProfile(ADDRESS_PROFILE_TABLE, PROFILE_1);
            this.profileUtils.getProfileProvisioningProxy().removeProfile(ADDRESS_PROFILE_TABLE, PROFILE_2);
            this.profileUtils.removeProfileTable(ADDRESS_PROFILE_TABLE);
        }
    }
}

