/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.convergencename.iesSetsAddress;

import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.AbstractConvergenceNameTest;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.InitialEventSelectorParameters;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.impl.AddressProfileProxyImpl;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.AddressPlan;

public class IesSetsAddressTest
extends AbstractConvergenceNameTest {
    private static final String PROFILE_1 = "PROFILE_1";
    private static final String PROFILE_2 = "PROFILE_2";
    private static final String ADDRESS_PROFILE_TABLE = "tck.AddressAndProfileTestProfile";
    private static final Address ADDRESS_1 = new Address(AddressPlan.IP, "1.0.0.1");
    private static final Address ADDRESS_2 = new Address(AddressPlan.IP, "1.0.0.2");
    private static final Address ADDRESS_3 = new Address(AddressPlan.IP, "1.0.0.3");
    private ProfileUtils profileUtils;

    public TCKTestResult run() throws Exception {
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("Test1924Activity");
        InitialEventSelectorParameters iesParams = new InitialEventSelectorParameters(true, false, true, false, false, null, false, false, false, null);
        this.sendEventAndWait("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "1", activityID, ADDRESS_1, "1", iesParams);
        iesParams = new InitialEventSelectorParameters(true, false, true, false, false, null, false, false, true, ADDRESS_3);
        this.sendEventAndWait("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "2", activityID, ADDRESS_2, "1", iesParams);
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileUtils.createStandardAddressProfileTable(ADDRESS_PROFILE_TABLE);
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_1, new Address[]{ADDRESS_1, ADDRESS_3});
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_2, new Address[]{ADDRESS_2});
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.profileUtils != null) {
            this.profileUtils.removeProfileTable(ADDRESS_PROFILE_TABLE);
        }
    }

    private void setupAddressProfile(String tableName, String profileName, Address[] addresses) throws Exception {
        ObjectName objectName = this.profileUtils.getProfileProvisioningProxy().createProfile(tableName, profileName);
        AddressProfileProxyImpl addressProfileProxy = new AddressProfileProxyImpl(objectName, this.utils().getMBeanFacade());
        addressProfileProxy.editProfile();
        addressProfileProxy.setAddresses(addresses);
        addressProfileProxy.commitProfile();
    }
}

