/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventcontext;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.events.eventcontext.Test1108021Sbb;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;

public class Test1108021Test
extends AbstractSleeTCKTest {
    public static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    public static final String activityNameA = "Test1108021Test-ActivityA";
    public static final String activityNameB = "Test1108021Test-ActivityB";
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private static final String testName = "Test1108021";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityA = resource.createActivity(activityNameA);
        TCKActivityID activityB = resource.createActivity(activityNameB);
        this.getLog().fine("Firing TCKResourceEventX1 on Test1108021Test-ActivityA.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", testName, activityA, null);
        Test1108021Test test1108021Test = this;
        synchronized (test1108021Test) {
            this.wait(1000L);
        }
        this.getLog().fine("Firing TCKResourceEventX2 on Test1108021Test-ActivityB.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", testName, activityB, null);
        test1108021Test = this;
        synchronized (test1108021Test) {
            this.wait(Test1108021Sbb.waitPeriodMs - 1000);
        }
        this.getLog().fine("Firing TCKResourceEventX3 on Test1108021Test-ActivityA.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3", testName, activityA, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        this.setupService(SERVICE_DU_PATH_PARAM, true);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1108021Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1108021Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1108021Test.this.result.setPassed();
            }
            catch (TCKTestFailureException ex) {
                Test1108021Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1108021Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1108021Test.this.getLog().warning(exception);
            Test1108021Test.this.result.setError(exception);
        }
    }
}

