/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.sbbabstractclass;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class Test1108074Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final String PROFILE_SPEC_DU_PATH_PARAM = "profileSpecDUPath";
    private TCKResourceListener resourceListener;
    private ProfileProvisioningMBeanProxy profileProvisioningMBeanProxy;
    private FutureResult result;
    private static final String testName = "Test1108074";
    private boolean tableCreated = false;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test1108074InitialActivity");
        this.getLog().fine("Firing TCKResourceEventX1 on Test1108074InitialActivity.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        this.setupService(SERVICE_DU_PATH_PARAM, true);
        this.getLog().fine("Installing profile spec");
        String profileSpecDUPath = this.utils().getTestParams().getProperty(PROFILE_SPEC_DU_PATH_PARAM);
        this.utils().install(profileSpecDUPath);
        this.getLog().fine("Creating a profile table, to create a profile table activity");
        ObjectName profileProvisioningName = this.utils().getSleeManagementMBeanProxy().getProfileProvisioningMBean();
        this.profileProvisioningMBeanProxy = this.utils().getMBeanProxyFactory().createProfileProvisioningMBeanProxy(profileProvisioningName);
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("SimpleProfile11", "jain.slee.tck", "1.1");
        this.getLog().info("Creating profile table: Test1108074ProfileTable");
        this.profileProvisioningMBeanProxy.createProfileTable(profileSpecID, "Test1108074ProfileTable");
        ObjectName profile = this.profileProvisioningMBeanProxy.createProfile("Test1108074ProfileTable", "Test1108074Profile");
        ProfileMBeanProxy profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        profProxy.commitProfile();
        this.tableCreated = true;
    }

    public void tearDown() throws Exception {
        if (this.profileProvisioningMBeanProxy != null && this.tableCreated) {
            try {
                this.getLog().fine("Removing profile table");
                this.profileProvisioningMBeanProxy.removeProfileTable("Test1108074ProfileTable");
            }
            catch (Exception e) {
                this.getLog().warning(e);
            }
        }
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = (String)sbbData.get("testname");
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1108074Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1108074Test.this.result.setPassed();
            }
            catch (TCKTestFailureException ex) {
                Test1108074Test.this.result.setFailed(1108074, "The SBB fired an event in the pooled state and did not receive an IllegalStateException");
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1108074Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1108074Test.this.getLog().warning(exception);
            Test1108074Test.this.result.setError(exception);
        }
    }
}

