/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.servicestarted;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Map;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceState;

public class Test1108105Test
extends AbstractSleeTCKTest {
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    private static final int defaultTimeout = 25000;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private static final int expectedCount = 3;
    private int receivedCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        Object service;
        this.result = result;
        this.getLog().fine("Installing and activating service1");
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.getLog().fine("Installing service2");
        String duPath = this.utils().getTestParams().getProperty(SERVICE2_DU_PATH_PARAM);
        DeployableUnitID duID = this.utils().install(duPath);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        ServiceManagementMBeanProxy serviceProxy = this.utils().getServiceManagementMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(duID);
        ComponentID[] components = duDesc.getComponents();
        ServiceID secondService = null;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            service = (ServiceID)components[i];
            if (secondService != null) continue;
            secondService = service;
        }
        if (secondService == null) {
            result.setError("Failed to find the second test services.");
            return;
        }
        this.getLog().fine("Activating service2");
        serviceProxy.activate(secondService);
        ServiceID[] services = serviceProxy.getServices(ServiceState.ACTIVE);
        if (services.length != 2 || !Arrays.asList(services).contains(secondService)) {
            result.setError("Failed to find two active service: found" + services.length + " instead.");
            return;
        }
        this.getLog().fine("The service " + secondService + " is in Active state");
        service = this;
        synchronized (service) {
            this.wait(25000L);
        }
        if (this.receivedCount == 3) {
            this.getLog().info("Test should be passed here!");
            result.setPassed();
        } else {
            result.setFailed(1108105, "Expected number of successful messages not received, messages werenot delivered by the SBBs (expected 3, received " + this.receivedCount + ")");
        }
        for (int i = 0; i < services.length; ++i) {
            serviceProxy.deactivate(services[i]);
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1108105Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1108105Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1108105Test.this.receivedCount++;
            }
            catch (TCKTestFailureException ex) {
                Test1108105Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1108105Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1108105Test.this.getLog().warning(exception);
            Test1108105Test.this.result.setError(exception);
        }
    }
}

